/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.view.animation.Interpolator;
import io.codetail.animation.SupportAnimator;
import java.lang.ref.WeakReference;

@TargetApi(value=11)
final class SupportAnimatorLollipop
extends SupportAnimator {
    WeakReference<Animator> mNativeAnimator;

    SupportAnimatorLollipop(Animator animator) {
        this.mNativeAnimator = new WeakReference<Animator>(animator);
    }

    @Override
    public boolean isNativeAnimator() {
        return true;
    }

    @Override
    public Object get() {
        return this.mNativeAnimator.get();
    }

    @Override
    public void start() {
        Animator a = (Animator)this.mNativeAnimator.get();
        if (a != null) {
            a.start();
        }
    }

    @Override
    public void setDuration(int duration) {
        Animator a = (Animator)this.mNativeAnimator.get();
        if (a != null) {
            a.setDuration((long)duration);
        }
    }

    @Override
    public void setInterpolator(Interpolator value) {
        Animator a = (Animator)this.mNativeAnimator.get();
        if (a != null) {
            a.setInterpolator((TimeInterpolator)value);
        }
    }

    @Override
    public void addListener(final SupportAnimator.AnimatorListener listener) {
        Animator a = (Animator)this.mNativeAnimator.get();
        if (a == null) {
            return;
        }
        if (listener == null) {
            a.addListener(null);
            return;
        }
        a.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                listener.onAnimationStart();
            }

            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd();
            }

            public void onAnimationCancel(Animator animation) {
                listener.onAnimationCancel();
            }

            public void onAnimationRepeat(Animator animation) {
                listener.onAnimationRepeat();
            }
        });
    }

    @Override
    public boolean isRunning() {
        Animator a = (Animator)this.mNativeAnimator.get();
        return a != null && a.isRunning();
    }
}

