/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng;

import android.graphics.BitmapFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import oupson.apng.Apng;
import oupson.apng.Frame;
import oupson.apng.chunks.IHDR;
import oupson.apng.chunks.fcTL;
import oupson.apng.exceptions.BadApng;
import oupson.apng.exceptions.BadCRC;
import oupson.apng.exceptions.NotApngException;
import oupson.apng.exceptions.NotPngException;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001aJ \u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010)\u001a\u00020(H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Loupson/apng/APNGDisassembler;", "", "()V", "apng", "Loupson/apng/Apng;", "getApng", "()Loupson/apng/Apng;", "setApng", "(Loupson/apng/Apng;)V", "blendOp", "Loupson/apng/utils/Utils$Companion$BlendOp;", "cover", "Ljava/util/ArrayList;", "", "delay", "", "disposeOp", "Loupson/apng/utils/Utils$Companion$DisposeOp;", "ihdr", "Loupson/apng/chunks/IHDR;", "isApng", "", "maxHeight", "", "maxWidth", "plte", "", "png", "tnrs", "xOffset", "yOffset", "disassemble", "input", "Ljava/io/InputStream;", "byteArray", "generateIhdr", "ihdrOfApng", "width", "height", "parseChunk", "", "reset", "apng_library_release"})
public final class APNGDisassembler {
    private ArrayList<Byte> png;
    private ArrayList<Byte> cover;
    private float delay = -1.0f;
    private int yOffset = -1;
    private int xOffset = -1;
    private byte[] plte;
    private byte[] tnrs;
    private int maxWidth;
    private int maxHeight;
    private Utils.Companion.BlendOp blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
    private Utils.Companion.DisposeOp disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
    private IHDR ihdr = new IHDR();
    private boolean isApng;
    @NotNull
    private Apng apng = new Apng();

    @NotNull
    public final Apng getApng() {
        return this.apng;
    }

    public final void setApng(@NotNull Apng apng) {
        Intrinsics.checkNotNullParameter((Object)apng, (String)"<set-?>");
        this.apng = apng;
    }

    @NotNull
    public final Apng disassemble(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.reset();
        if (Utils.Companion.isApng(byteArray)) {
            int length;
            for (int cursor = 8; cursor < byteArray.length; cursor += length + 12) {
                byte[] byArray = byteArray;
                int n = cursor + 4;
                int n2 = 0;
                length = Utils.Companion.parseLength(ArraysKt.copyOfRange((byte[])byArray, (int)cursor, (int)n));
                byte[] byArray2 = byteArray;
                n2 = cursor + length + 12;
                boolean bl = false;
                byte[] chunk = ArraysKt.copyOfRange((byte[])byArray2, (int)cursor, (int)n2);
                this.parseChunk(chunk);
            }
            return this.apng;
        }
        throw (Throwable)new NotApngException();
    }

    @NotNull
    public final Apng disassemble(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.reset();
        byte[] buffer = new byte[8];
        input.read(buffer);
        if (!Utils.Companion.isPng(buffer)) {
            throw (Throwable)new NotPngException();
        }
        int byteRead = 0;
        byte[] lengthChunk = new byte[4];
        while ((byteRead = input.read(lengthChunk)) != -1) {
            int length = Utils.Companion.parseLength(lengthChunk);
            byte[] chunk = new byte[length + 8];
            byteRead = input.read(chunk);
            this.parseChunk(ArraysKt.plus((byte[])lengthChunk, (byte[])chunk));
            if (byteRead != -1) continue;
        }
        return this.apng;
    }

    private final byte[] generateIhdr(IHDR ihdrOfApng, int width, int height) {
        ArrayList ihdr = new ArrayList();
        ArrayList ihdrBody = new ArrayList();
        ihdr.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(ihdrOfApng.getBody().length)));
        ihdrBody.addAll(ArraysKt.asList((byte[])new byte[]{(byte)73, (byte)72, (byte)68, (byte)82}));
        ihdrBody.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(width)));
        ihdrBody.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(height)));
        byte[] byArray = ihdrOfApng.getBody();
        int n = 8;
        int n2 = 13;
        boolean bl = false;
        ihdrBody.addAll(ArraysKt.asList((byte[])ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2)));
        CRC32 crC32 = new CRC32();
        crC32.update(CollectionsKt.toByteArray((Collection)ihdrBody), 0, ihdrBody.size());
        ihdr.addAll(ihdrBody);
        ihdr.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)crC32.getValue())));
        return CollectionsKt.toByteArray((Collection)ihdr);
    }

    private final void parseChunk(byte[] byteArray) {
        int i = 4;
        byte[] byArray = byteArray;
        int n = byteArray.length - 4;
        int n2 = byteArray.length;
        int n3 = 0;
        int chunkCRC = Utils.Companion.parseLength(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        CRC32 crc = new CRC32();
        byte[] byArray2 = byteArray;
        n2 = byteArray.length - 4;
        n3 = 0;
        crc.update(ArraysKt.copyOfRange((byte[])byArray2, (int)i, (int)n2));
        if (chunkCRC == (int)crc.getValue()) {
            Object crC32;
            Object iend;
            Object object = byteArray;
            n3 = i + 4;
            boolean bl = false;
            byte[] name = ArraysKt.copyOfRange((byte[])object, (int)i, (int)n3);
            object = name;
            byte[] byArray3 = Utils.Companion.getFcTL();
            bl = false;
            if (Arrays.equals(object, byArray3)) {
                if (this.png == null) {
                    Boolean bl2;
                    Boolean bl3;
                    Object it;
                    Unit unit;
                    boolean bl4;
                    Object it2;
                    ArrayList<Byte> arrayList = this.cover;
                    if (arrayList != null) {
                        object = arrayList;
                        boolean bl5 = false;
                        bl = false;
                        it2 = object;
                        bl4 = false;
                        it2.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(0)));
                        byte[] iend2 = new byte[]{73, 69, 78, 68};
                        CRC32 crC322 = new CRC32();
                        crC322.update(iend2, 0, iend2.length);
                        it2.addAll(ArraysKt.asList((byte[])iend2));
                        it2.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)crC322.getValue())));
                        this.apng.setCover(BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)((Collection)it2)), (int)0, (int)it2.size()));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    this.png = new ArrayList();
                    fcTL fcTL2 = new fcTL();
                    fcTL2.parse(byteArray);
                    this.delay = fcTL2.getDelay();
                    this.yOffset = fcTL2.getYOffset();
                    this.xOffset = fcTL2.getXOffset();
                    this.blendOp = fcTL2.getBlendOp();
                    this.disposeOp = fcTL2.getDisposeOp();
                    int width = fcTL2.getPngWidth();
                    int height = fcTL2.getPngHeight();
                    if (this.xOffset + width > this.maxWidth) {
                        throw (Throwable)new BadApng("`yOffset` + `height` must be <= `IHDR` height");
                    }
                    if (this.yOffset + height > this.maxHeight) {
                        throw (Throwable)new BadApng("`yOffset` + `height` must be <= `IHDR` height");
                    }
                    ArrayList<Byte> arrayList2 = this.png;
                    Boolean bl6 = arrayList2 != null ? Boolean.valueOf(arrayList2.addAll(ArraysKt.asList((byte[])Utils.Companion.getPngSignature()))) : null;
                    ArrayList<Byte> arrayList3 = this.png;
                    Boolean bl7 = arrayList3 != null ? Boolean.valueOf(arrayList3.addAll(ArraysKt.asList((byte[])this.generateIhdr(this.ihdr, width, height)))) : null;
                    if (this.plte != null) {
                        it2 = this.plte;
                        bl4 = false;
                        boolean iend2 = false;
                        it = it2;
                        boolean bl8 = false;
                        ArrayList<Byte> arrayList4 = this.png;
                        bl3 = arrayList4 != null ? Boolean.valueOf(arrayList4.addAll(ArraysKt.asList((byte[])it))) : null;
                    } else {
                        bl3 = null;
                    }
                    if (this.tnrs != null) {
                        it2 = this.tnrs;
                        bl4 = false;
                        boolean iend2 = false;
                        it = it2;
                        boolean bl9 = false;
                        ArrayList<Byte> arrayList5 = this.png;
                        bl2 = arrayList5 != null ? Boolean.valueOf(arrayList5.addAll(ArraysKt.asList((byte[])it))) : null;
                    } else {
                        bl2 = null;
                    }
                } else {
                    Boolean bl10;
                    Boolean bl11;
                    byte[] it;
                    boolean bl12;
                    boolean it3;
                    byte[] iend2;
                    ArrayList<Byte> arrayList = this.png;
                    Boolean bl13 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(0)))) : null;
                    iend = new byte[]{73, 69, 78, 68};
                    crC32 = new CRC32();
                    ((CRC32)crC32).update((byte[])iend, 0, ((Object)iend).length);
                    ArrayList<Byte> arrayList6 = this.png;
                    Boolean bl14 = arrayList6 != null ? Boolean.valueOf(arrayList6.addAll(ArraysKt.asList((byte[])iend))) : null;
                    ArrayList<Byte> arrayList7 = this.png;
                    Boolean bl15 = arrayList7 != null ? Boolean.valueOf(arrayList7.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)((CRC32)crC32).getValue())))) : null;
                    ArrayList<Frame> arrayList8 = this.apng.getFrames();
                    ArrayList<Byte> arrayList9 = this.png;
                    Intrinsics.checkNotNull(arrayList9);
                    arrayList8.add(new Frame(CollectionsKt.toByteArray((Collection)arrayList9), this.delay, this.xOffset, this.yOffset, this.blendOp, this.disposeOp, this.maxWidth, this.maxHeight));
                    this.png = new ArrayList();
                    fcTL fcTL32 = new fcTL();
                    fcTL32.parse(byteArray);
                    this.delay = fcTL32.getDelay();
                    this.yOffset = fcTL32.getYOffset();
                    this.xOffset = fcTL32.getXOffset();
                    this.blendOp = fcTL32.getBlendOp();
                    this.disposeOp = fcTL32.getDisposeOp();
                    int width = fcTL32.getPngWidth();
                    int height = fcTL32.getPngHeight();
                    ArrayList<Byte> arrayList10 = this.png;
                    Boolean bl16 = arrayList10 != null ? Boolean.valueOf(arrayList10.addAll(ArraysKt.asList((byte[])Utils.Companion.getPngSignature()))) : null;
                    ArrayList<Byte> arrayList11 = this.png;
                    Boolean bl17 = arrayList11 != null ? Boolean.valueOf(arrayList11.addAll(ArraysKt.asList((byte[])this.generateIhdr(this.ihdr, width, height)))) : null;
                    if (this.plte != null) {
                        iend2 = this.plte;
                        it3 = false;
                        bl12 = false;
                        it = iend2;
                        boolean bl18 = false;
                        ArrayList<Byte> arrayList12 = this.png;
                        bl11 = arrayList12 != null ? Boolean.valueOf(arrayList12.addAll(ArraysKt.asList((byte[])it))) : null;
                    } else {
                        bl11 = null;
                    }
                    if (this.tnrs != null) {
                        iend2 = this.tnrs;
                        it3 = false;
                        bl12 = false;
                        it = iend2;
                        boolean bl19 = false;
                        ArrayList<Byte> arrayList13 = this.png;
                        bl10 = arrayList13 != null ? Boolean.valueOf(arrayList13.addAll(ArraysKt.asList((byte[])it))) : null;
                    } else {
                        bl10 = null;
                    }
                }
            } else {
                iend = name;
                crC32 = Utils.Companion.getIEND();
                int fcTL32 = 0;
                if (Arrays.equals(iend, (byte[])crC32)) {
                    if (this.isApng) {
                        ArrayList<Byte> arrayList = this.png;
                        Boolean bl20 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(0)))) : null;
                        iend = new byte[]{73, 69, 78, 68};
                        crC32 = new CRC32();
                        ((CRC32)crC32).update((byte[])iend, 0, ((byte[])iend).length);
                        ArrayList<Byte> arrayList14 = this.png;
                        Boolean bl21 = arrayList14 != null ? Boolean.valueOf(arrayList14.addAll(ArraysKt.asList((byte[])iend))) : null;
                        ArrayList<Byte> arrayList15 = this.png;
                        Boolean bl22 = arrayList15 != null ? Boolean.valueOf(arrayList15.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)((CRC32)crC32).getValue())))) : null;
                        ArrayList<Frame> arrayList16 = this.apng.getFrames();
                        ArrayList<Byte> arrayList17 = this.png;
                        Intrinsics.checkNotNull(arrayList17);
                        arrayList16.add(new Frame(CollectionsKt.toByteArray((Collection)arrayList17), this.delay, this.xOffset, this.yOffset, this.blendOp, this.disposeOp, this.maxWidth, this.maxHeight));
                    } else {
                        Unit unit;
                        ArrayList<Byte> arrayList = this.cover;
                        if (arrayList != null) {
                            iend = arrayList;
                            boolean crC323 = false;
                            fcTL32 = 0;
                            byte[] it = iend;
                            boolean bl23 = false;
                            it.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(0)));
                            byte[] iend3 = new byte[]{73, 69, 78, 68};
                            CRC32 crC324 = new CRC32();
                            crC324.update(iend3, 0, iend3.length);
                            it.addAll(ArraysKt.asList((byte[])iend3));
                            it.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)crC324.getValue())));
                            this.apng.setCover(BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)((Collection)it)), (int)0, (int)it.size()));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        this.apng.setApng(false);
                    }
                } else {
                    Object body;
                    iend = name;
                    crC32 = Utils.Companion.getIDAT();
                    fcTL32 = 0;
                    if (Arrays.equals(iend, (byte[])crC32)) {
                        if (this.png == null) {
                            Boolean bl24;
                            if (this.cover == null) {
                                ArrayList<Byte> arrayList = this.cover = new ArrayList();
                                Boolean bl25 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.asList((byte[])Utils.Companion.getPngSignature()))) : null;
                                ArrayList<Byte> arrayList18 = this.cover;
                                Boolean bl26 = arrayList18 != null ? Boolean.valueOf(arrayList18.addAll(ArraysKt.asList((byte[])this.generateIhdr(this.ihdr, this.maxWidth, this.maxHeight)))) : null;
                            }
                            crC32 = byteArray;
                            fcTL32 = i - 4;
                            int n4 = 0;
                            int bodySize = Utils.Companion.parseLength(ArraysKt.copyOfRange((byte[])crC32, (int)fcTL32, (int)i));
                            ArrayList<Byte> arrayList = this.cover;
                            if (arrayList != null) {
                                crC32 = byteArray;
                                fcTL32 = i - 4;
                                n4 = 0;
                                bl24 = arrayList.addAll(ArraysKt.asList((byte[])ArraysKt.copyOfRange((byte[])crC32, (int)fcTL32, (int)i)));
                            } else {
                                bl24 = null;
                            }
                            body = new ArrayList();
                            ((ArrayList)body).addAll(ArraysKt.asList((byte[])new byte[]{73, 68, 65, 84}));
                            byte[] fcTL32 = byteArray;
                            n4 = i + 4;
                            int n5 = i + 4 + bodySize;
                            boolean bl27 = false;
                            ((ArrayList)body).addAll(ArraysKt.asList((byte[])ArraysKt.copyOfRange((byte[])fcTL32, (int)n4, (int)n5)));
                            CRC32 crC33 = new CRC32();
                            crC33.update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                            ArrayList<Byte> arrayList19 = this.cover;
                            Boolean bl28 = arrayList19 != null ? Boolean.valueOf(arrayList19.addAll((Collection)body)) : null;
                            ArrayList<Byte> arrayList20 = this.cover;
                            Boolean bl29 = arrayList20 != null ? Boolean.valueOf(arrayList20.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)crC33.getValue())))) : null;
                        } else {
                            Boolean bl30;
                            body = byteArray;
                            int crC34 = i - 4;
                            int n6 = 0;
                            int bodySize = Utils.Companion.parseLength(ArraysKt.copyOfRange((byte[])body, (int)crC34, (int)i));
                            ArrayList<Byte> arrayList = this.png;
                            if (arrayList != null) {
                                body = byteArray;
                                crC34 = i - 4;
                                n6 = 0;
                                bl30 = arrayList.addAll(ArraysKt.asList((byte[])ArraysKt.copyOfRange((byte[])body, (int)crC34, (int)i)));
                            } else {
                                bl30 = null;
                            }
                            body = new ArrayList();
                            ((ArrayList)body).addAll(ArraysKt.asList((byte[])new byte[]{73, 68, 65, 84}));
                            Object crC33 = byteArray;
                            n6 = i + 4;
                            int n7 = i + 4 + bodySize;
                            boolean bl31 = false;
                            ((ArrayList)body).addAll(ArraysKt.asList((byte[])ArraysKt.copyOfRange((byte[])crC33, (int)n6, (int)n7)));
                            crC33 = new CRC32();
                            ((CRC32)crC33).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                            ArrayList<Byte> arrayList21 = this.png;
                            Boolean bl32 = arrayList21 != null ? Boolean.valueOf(arrayList21.addAll((Collection)body)) : null;
                            ArrayList<Byte> arrayList22 = this.png;
                            Boolean bl33 = arrayList22 != null ? Boolean.valueOf(arrayList22.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)((CRC32)crC33).getValue())))) : null;
                        }
                    } else {
                        byte[] bodySize = name;
                        body = Utils.Companion.getFdAT();
                        crC34 = 0;
                        if (Arrays.equals(bodySize, (byte[])body)) {
                            body = byteArray;
                            crC34 = i - 4;
                            int n8 = 0;
                            int bodySize2 = Utils.Companion.parseLength(ArraysKt.copyOfRange((byte[])body, (int)crC34, (int)i));
                            ArrayList<Byte> arrayList = this.png;
                            Boolean bl34 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes(bodySize2 - 4)))) : null;
                            body = new ArrayList();
                            ((ArrayList)body).addAll(ArraysKt.asList((byte[])new byte[]{73, 68, 65, 84}));
                            Object crC34 = byteArray;
                            n8 = i + 8;
                            int n9 = i + 4 + bodySize2;
                            boolean bl35 = false;
                            ((ArrayList)body).addAll(ArraysKt.asList((byte[])ArraysKt.copyOfRange((byte[])crC34, (int)n8, (int)n9)));
                            crC34 = new CRC32();
                            ((CRC32)crC34).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                            ArrayList<Byte> arrayList23 = this.png;
                            Boolean bl36 = arrayList23 != null ? Boolean.valueOf(arrayList23.addAll((Collection)body)) : null;
                            ArrayList<Byte> arrayList24 = this.png;
                            Boolean bl37 = arrayList24 != null ? Boolean.valueOf(arrayList24.addAll(ArraysKt.asList((Object[])Utils.Companion.to4Bytes((int)((CRC32)crC34).getValue())))) : null;
                        } else {
                            object = name;
                            byArray3 = Utils.Companion.getPlte();
                            bl = false;
                            if (Arrays.equals(object, byArray3)) {
                                this.plte = byteArray;
                            } else {
                                object = name;
                                byArray3 = Utils.Companion.getTnrs();
                                bl = false;
                                if (Arrays.equals(object, byArray3)) {
                                    this.tnrs = byteArray;
                                } else {
                                    object = name;
                                    byArray3 = Utils.Companion.getIHDR();
                                    bl = false;
                                    if (Arrays.equals(object, byArray3)) {
                                        this.ihdr.parse(byteArray);
                                        this.maxWidth = this.ihdr.getPngWidth();
                                        this.maxHeight = this.ihdr.getPngHeight();
                                    } else {
                                        object = name;
                                        byArray3 = Utils.Companion.getAcTL();
                                        bl = false;
                                        if (Arrays.equals(object, byArray3)) {
                                            this.isApng = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw (Throwable)new BadCRC();
        }
    }

    private final void reset() {
        this.png = null;
        this.cover = null;
        this.delay = -1.0f;
        this.yOffset = -1;
        this.xOffset = -1;
        this.plte = null;
        this.tnrs = null;
        this.maxWidth = 0;
        this.maxHeight = 0;
        this.ihdr = new IHDR();
        this.apng = new Apng();
        this.isApng = false;
    }
}

