/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.platform.linux.LinuxDisks;
import oshi.hardware.platform.mac.MacDisks;
import oshi.hardware.platform.unix.freebsd.FreeBsdDisks;
import oshi.hardware.platform.unix.solaris.SolarisDisks;
import oshi.hardware.platform.windows.WindowsDisks;
import oshi.json.SystemInfo;
import oshi.json.hardware.HWPartition;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class HWDiskStore
extends AbstractOshiJsonObject
implements Comparable<HWDiskStore> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HWDiskStore.class);
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.HWDiskStore hwDiskStore;

    public HWDiskStore() {
        this.hwDiskStore = new oshi.hardware.HWDiskStore();
    }

    public HWDiskStore(oshi.hardware.HWDiskStore diskStore) {
        this.hwDiskStore = new oshi.hardware.HWDiskStore(diskStore);
    }

    public boolean updateDiskStats() {
        boolean diskFound = false;
        switch (SystemInfo.getCurrentPlatformEnum()) {
            case WINDOWS: {
                diskFound = WindowsDisks.updateDiskStats(this.hwDiskStore);
                break;
            }
            case LINUX: {
                diskFound = LinuxDisks.updateDiskStats(this.hwDiskStore);
                break;
            }
            case MACOSX: {
                diskFound = MacDisks.updateDiskStats(this.hwDiskStore);
                break;
            }
            case SOLARIS: {
                diskFound = SolarisDisks.updateDiskStats(this.hwDiskStore);
                break;
            }
            case FREEBSD: {
                diskFound = FreeBsdDisks.updateDiskStats(this.hwDiskStore);
                break;
            }
            default: {
                LOG.error("Unsupported platform. No update performed.");
            }
        }
        return diskFound;
    }

    public String getName() {
        return this.hwDiskStore.getName();
    }

    public String getModel() {
        return this.hwDiskStore.getModel();
    }

    public String getSerial() {
        return this.hwDiskStore.getSerial();
    }

    public long getSize() {
        return this.hwDiskStore.getSize();
    }

    public long getReads() {
        return this.hwDiskStore.getReads();
    }

    public long getReadBytes() {
        return this.hwDiskStore.getReadBytes();
    }

    public long getWrites() {
        return this.hwDiskStore.getWrites();
    }

    public long getWriteBytes() {
        return this.hwDiskStore.getWriteBytes();
    }

    public long getCurrentQueueLength() {
        return this.hwDiskStore.getCurrentQueueLength();
    }

    public long getTransferTime() {
        return this.hwDiskStore.getTransferTime();
    }

    public HWPartition[] getPartitions() {
        HWPartition[] partitions = new HWPartition[this.hwDiskStore.getPartitions().length];
        for (int i = 0; i < partitions.length; ++i) {
            partitions[i] = new HWPartition(this.hwDiskStore.getPartitions()[i].getIdentification(), this.hwDiskStore.getPartitions()[i].getName(), this.hwDiskStore.getPartitions()[i].getType(), this.hwDiskStore.getPartitions()[i].getUuid(), this.hwDiskStore.getPartitions()[i].getSize(), this.hwDiskStore.getPartitions()[i].getMajor(), this.hwDiskStore.getPartitions()[i].getMinor(), this.hwDiskStore.getPartitions()[i].getMountPoint());
        }
        return partitions;
    }

    public long getTimeStamp() {
        return this.hwDiskStore.getTimeStamp();
    }

    public void setName(String name) {
        this.hwDiskStore.setName(name);
    }

    public void setModel(String model) {
        this.hwDiskStore.setModel(model);
    }

    public void setSerial(String serial) {
        this.hwDiskStore.setSerial(serial);
    }

    public void setSize(long size) {
        this.hwDiskStore.setSize(size);
    }

    public void setReads(long reads) {
        this.hwDiskStore.setReads(reads);
    }

    public void setReadBytes(long readBytes) {
        this.hwDiskStore.setReadBytes(readBytes);
    }

    public void setWrites(long writes) {
        this.hwDiskStore.setWrites(writes);
    }

    public void setWriteBytes(long writeBytes) {
        this.hwDiskStore.setWriteBytes(writeBytes);
    }

    public void setCurrentQueueLength(long currentQueueLength) {
        this.hwDiskStore.setCurrentQueueLength(currentQueueLength);
    }

    public void setTransferTime(long transferTime) {
        this.hwDiskStore.setTransferTime(transferTime);
    }

    public void setPartitions(HWPartition[] partitions) {
        oshi.hardware.HWPartition[] parts = new oshi.hardware.HWPartition[partitions.length];
        for (int i = 0; i < partitions.length; ++i) {
            parts[i] = new oshi.hardware.HWPartition(partitions[i].getIdentification(), partitions[i].getName(), partitions[i].getType(), partitions[i].getUuid(), partitions[i].getSize(), partitions[i].getMajor(), partitions[i].getMinor(), partitions[i].getMountPoint());
        }
        this.hwDiskStore.setPartitions(parts);
    }

    public void setTimeStamp(long timeStamp) {
        this.hwDiskStore.setTimeStamp(timeStamp);
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.name")) {
            json.add("name", this.hwDiskStore.getName());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.model")) {
            json.add("model", this.hwDiskStore.getModel());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.serial")) {
            json.add("serial", this.hwDiskStore.getSerial());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.size")) {
            json.add("size", this.hwDiskStore.getSize());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.reads")) {
            json.add("reads", this.hwDiskStore.getReads());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.readBytes")) {
            json.add("readBytes", this.hwDiskStore.getReadBytes());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.writes")) {
            json.add("writes", this.hwDiskStore.getWrites());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.writeBytes")) {
            json.add("writeBytes", this.hwDiskStore.getWriteBytes());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.queueLength")) {
            json.add("currentQueueLength", this.hwDiskStore.getCurrentQueueLength());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.transferTime")) {
            json.add("transferTime", this.hwDiskStore.getTransferTime());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.partitions")) {
            JsonArrayBuilder partitionArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (HWPartition partition : this.getPartitions()) {
                partitionArrayBuilder.add((JsonValue)partition.toJSON(properties));
            }
            json.add("partitions", (JsonValue)partitionArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.timeStamp")) {
            json.add("timeStamp", this.hwDiskStore.getTimeStamp());
        }
        return json.build();
    }

    @Override
    public int compareTo(HWDiskStore store) {
        return this.hwDiskStore.compareTo(store.hwDiskStore);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hwDiskStore == null ? 0 : this.hwDiskStore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HWDiskStore)) {
            return false;
        }
        HWDiskStore other = (HWDiskStore)obj;
        return !(this.hwDiskStore == null ? other.hwDiskStore != null : !this.hwDiskStore.equals(other.hwDiskStore));
    }
}

