/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.Ole32;
import oshi.jna.platform.windows.Wbemcli;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.ParseUtil;

public class WmiUtil {
    public static final WmiUtil INSTANCE = new WmiUtil();
    private static final Logger LOG = LoggerFactory.getLogger(WmiUtil.class);
    private static int wmiTimeout = -1;
    private static int connectionCacheTimeout = 300000;
    private static Set<String> hasNamespaceCache = new HashSet<String>();
    private static Set<String> hasNotNamespaceCache = new HashSet<String>();
    private static Set<String> failedWmiClassNames = new HashSet<String>();
    public static final String OHM_NAMESPACE = "ROOT\\OpenHardwareMonitor";
    private static final String CLASS_CAST_MSG = "%s is not a %s type. CIM Type is %d and VT type is %d";
    private static boolean comInitialized = false;
    private static boolean securityInitialized = false;

    private WmiUtil() {
        WmiUtil.initCOM();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WmiUtil.unInitCOM();
            }
        });
    }

    public static boolean hasNamespace(String namespace) {
        if (hasNamespaceCache.contains(namespace)) {
            return true;
        }
        if (hasNotNamespaceCache.contains(namespace)) {
            return false;
        }
        if (WbemcliUtil.hasNamespace(namespace)) {
            hasNamespaceCache.add(namespace);
            return true;
        }
        hasNotNamespaceCache.add(namespace);
        return false;
    }

    public static <T extends Enum<T>> WbemcliUtil.WmiResult<T> queryWMI(WbemcliUtil.WmiQuery<T> query) {
        WbemcliUtil wbemcliUtil = WbemcliUtil.INSTANCE;
        wbemcliUtil.getClass();
        WbemcliUtil.WmiResult<T> result = wbemcliUtil.new WbemcliUtil.WmiResult<T>(query.getPropertyEnum());
        if (failedWmiClassNames.contains(query.getWmiClassName())) {
            return result;
        }
        try {
            if (!WmiUtil.isComInitialized()) {
                WmiUtil.initCOM();
            }
            result = query.execute(wmiTimeout);
        }
        catch (COMException e) {
            if (!OHM_NAMESPACE.equals(query.getNameSpace())) {
                failedWmiClassNames.add(query.getWmiClassName());
                LOG.warn("COM exception querying {}, which might not be on your system. Will not attempt to query it again. Error was: {}:", (Object)query.getWmiClassName(), (Object)e.getMessage());
            }
        }
        catch (TimeoutException e) {
            Enum[] props = (Enum[])query.getPropertyEnum().getEnumConstants();
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(props[0].name());
            for (int i = 1; i < props.length; ++i) {
                sb.append(',').append(props[i].name());
            }
            sb.append(" FROM ").append(query.getWmiClassName());
            LOG.error("WMI query timed out after {} ms: {}", (Object)wmiTimeout, (Object)sb);
        }
        return result;
    }

    public static <T extends Enum<T>> String getString(WbemcliUtil.WmiResult<T> result, T property, int index) {
        if (result.getCIMType(property) == 8) {
            return WmiUtil.getStr(result, property, index);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "String", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> String getDateString(WbemcliUtil.WmiResult<T> result, T property, int index) {
        if (result.getCIMType(property) == 101) {
            String date = WmiUtil.getStr(result, property, index);
            return date.substring(0, 4) + '-' + date.substring(4, 6) + '-' + date.substring(6, 8);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "DateTime", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> String getRefString(WbemcliUtil.WmiResult<T> result, T property, int index) {
        if (result.getCIMType(property) == 102) {
            return WmiUtil.getStr(result, property, index);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "Reference", result.getCIMType(property), result.getVtType(property)));
    }

    private static <T extends Enum<T>> String getStr(WbemcliUtil.WmiResult<T> result, T property, int index) {
        Object o = result.getValue(property, index);
        if (o == null) {
            return "";
        }
        if (result.getVtType(property) == 8) {
            return (String)o;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "String-mapped", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> long getUint64(WbemcliUtil.WmiResult<T> result, T property, int index) {
        Object o = result.getValue(property, index);
        if (o == null) {
            return 0L;
        }
        if (result.getCIMType(property) == 21 && result.getVtType(property) == 8) {
            return ParseUtil.parseLongOrDefault((String)o, 0L);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT64", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> int getUint32(WbemcliUtil.WmiResult<T> result, T property, int index) {
        if (result.getCIMType(property) == 19) {
            return WmiUtil.getInt(result, property, index);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT32", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> long getUint32asLong(WbemcliUtil.WmiResult<T> result, T property, int index) {
        if (result.getCIMType(property) == 19) {
            return (long)WmiUtil.getInt(result, property, index) & 0xFFFFFFFFL;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT32", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> int getSint32(WbemcliUtil.WmiResult<T> result, T property, int index) {
        if (result.getCIMType(property) == 3) {
            return WmiUtil.getInt(result, property, index);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "SINT32", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> int getUint16(WbemcliUtil.WmiResult<T> result, T property, int index) {
        if (result.getCIMType(property) == 18) {
            return WmiUtil.getInt(result, property, index);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT16", result.getCIMType(property), result.getVtType(property)));
    }

    private static <T extends Enum<T>> int getInt(WbemcliUtil.WmiResult<T> result, T property, int index) {
        Object o = result.getValue(property, index);
        if (o == null) {
            return 0;
        }
        if (result.getVtType(property) == 3) {
            return (Integer)o;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "32-bit integer", result.getCIMType(property), result.getVtType(property)));
    }

    public static <T extends Enum<T>> float getFloat(WbemcliUtil.WmiResult<T> result, T property, int index) {
        Object o = result.getValue(property, index);
        if (o == null) {
            return 0.0f;
        }
        if (result.getCIMType(property) == 4 && result.getVtType(property) == 4) {
            return ((Float)o).floatValue();
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "Float", result.getCIMType(property), result.getVtType(property)));
    }

    public static void initCOM() {
        WinNT.HRESULT hres = null;
        if (!WmiUtil.isComInitialized()) {
            hres = Ole32.INSTANCE.CoInitializeEx(null, 0);
            switch (hres.intValue()) {
                case 0: {
                    comInitialized = true;
                    break;
                }
                case -2147417850: 
                case 1: {
                    break;
                }
                default: {
                    throw new COMException("Failed to initialize COM library.");
                }
            }
        }
        if (!WmiUtil.isSecurityInitialized()) {
            hres = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
            if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
                Ole32.INSTANCE.CoUninitialize();
                throw new COMException("Failed to initialize security.");
            }
            securityInitialized = true;
        }
    }

    public static void unInitCOM() {
        if (WmiUtil.isComInitialized()) {
            Ole32.INSTANCE.CoUninitialize();
            comInitialized = false;
        }
    }

    public static boolean isComInitialized() {
        return comInitialized;
    }

    public static boolean isSecurityInitialized() {
        return securityInitialized;
    }

    public static int getWmiTimeout() {
        return wmiTimeout;
    }

    public static void setWmiTimeout(int wmiTimeout) {
        WmiUtil.wmiTimeout = wmiTimeout;
    }

    public class WmiConnection {
        private long staleAfter;
        private Wbemcli.IWbemServices svc;

        WmiConnection(Wbemcli.IWbemServices svc) {
            this.svc = svc;
            this.refresh();
        }

        public Wbemcli.IWbemServices getService() {
            return this.svc;
        }

        public boolean isStale() {
            return System.currentTimeMillis() > this.staleAfter;
        }

        public void refresh() {
            this.staleAfter = System.currentTimeMillis() + (long)connectionCacheTimeout;
        }

        public void close() {
            this.svc.Release();
        }
    }
}

