/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.IPHlpAPI;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsNetworkParams
extends AbstractNetworkParams {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworkParams.class);
    private static final String IPV4_DEFAULT_DEST = "0.0.0.0/0";
    private static final String IPV6_DEFAULT_DEST = "::/0";
    private static final int COMPUTER_NAME_DNS_DOMAIN_FULLY_QUALIFIED = 3;
    private static final String NETROUTE_BASE_CLASS = "MSFT_NetRoute";
    private static final WbemcliUtil.WmiQuery<NetRouteProperty> NETROUTE_QUERY = WbemcliUtil.createQuery("ROOT\\StandardCimv2", null, NetRouteProperty.class);
    private static final String IP4ROUTE_BASE_CLASS = "Win32_IP4RouteTable";
    private static final WbemcliUtil.WmiQuery<IP4RouteProperty> IP4ROUTE_QUERY = WbemcliUtil.createQuery(null, IP4RouteProperty.class);

    @Override
    public String getDomainName() {
        char[] buffer = new char[256];
        IntByReference bufferSize = new IntByReference(buffer.length);
        if (!Kernel32.INSTANCE.GetComputerNameEx(3, buffer, bufferSize)) {
            LOG.error("Failed to get dns domain name. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return "";
        }
        return new String(buffer).trim();
    }

    @Override
    public String[] getDnsServers() {
        IntByReference bufferSize = new IntByReference();
        int ret = IPHlpAPI.INSTANCE.GetNetworkParams(null, bufferSize);
        if (ret != 111) {
            LOG.error("Failed to get network parameters buffer size. Error code: {}", (Object)ret);
            return new String[0];
        }
        Memory buffer = new Memory((long)bufferSize.getValue());
        ret = IPHlpAPI.INSTANCE.GetNetworkParams((Pointer)buffer, bufferSize);
        if (ret != 0) {
            LOG.error("Failed to get network parameters. Error code: {}", (Object)ret);
            return new String[0];
        }
        IPHlpAPI.FIXED_INFO fixedInfo = new IPHlpAPI.FIXED_INFO((Pointer)buffer);
        ArrayList<String> list = new ArrayList<String>();
        IPHlpAPI.IP_ADDR_STRING dns = fixedInfo.DnsServerList;
        while (dns != null) {
            String addr = new String(dns.IpAddress.String);
            int nullPos = addr.indexOf(0);
            if (nullPos != -1) {
                addr = addr.substring(0, nullPos);
            }
            list.add(addr);
            dns = dns.Next;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getIpv4DefaultGateway() {
        if (WmiUtil.hasNamespace("StandardCimv2")) {
            return this.getNextHop(IPV4_DEFAULT_DEST);
        }
        return this.getNextHopWin7(IPV4_DEFAULT_DEST.split("/")[0]);
    }

    @Override
    public String getIpv6DefaultGateway() {
        if (WmiUtil.hasNamespace("StandardCimv2")) {
            return this.getNextHop(IPV6_DEFAULT_DEST);
        }
        return this.parseIpv6Route();
    }

    private String getNextHop(String dest) {
        StringBuilder sb = new StringBuilder(NETROUTE_BASE_CLASS);
        sb.append(" WHERE DestinationPrefix=\"").append(dest).append('\"');
        NETROUTE_QUERY.setWmiClassName(sb.toString());
        WbemcliUtil.WmiResult<NetRouteProperty> vals = WmiUtil.queryWMI(NETROUTE_QUERY);
        if (vals.getResultCount() < 1) {
            return "";
        }
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < vals.getResultCount(); ++i) {
            int metric = WmiUtil.getUint32(vals, NetRouteProperty.ROUTEMETRIC, i);
            if (metric >= min) continue;
            min = metric;
            index = i;
        }
        return WmiUtil.getString(vals, NetRouteProperty.NEXTHOP, index);
    }

    private String getNextHopWin7(String dest) {
        StringBuilder sb = new StringBuilder(IP4ROUTE_BASE_CLASS);
        sb.append(" WHERE Destination=\"").append(dest).append('\"');
        IP4ROUTE_QUERY.setWmiClassName(sb.toString());
        WbemcliUtil.WmiResult<IP4RouteProperty> vals = WmiUtil.queryWMI(IP4ROUTE_QUERY);
        if (vals.getResultCount() < 1) {
            return "";
        }
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < vals.getResultCount(); ++i) {
            int metric = WmiUtil.getSint32(vals, IP4RouteProperty.METRIC1, i);
            if (metric >= min) continue;
            min = metric;
            index = i;
        }
        return WmiUtil.getString(vals, IP4RouteProperty.NEXTHOP, index);
    }

    private String parseIpv6Route() {
        List<String> lines = ExecutingCommand.runNative("route print -6 ::/0");
        for (String line : lines) {
            String[] fields = ParseUtil.whitespaces.split(line.trim());
            if (fields.length <= 3 || !IPV6_DEFAULT_DEST.equals(fields[2])) continue;
            return fields[3];
        }
        return "";
    }

    static enum IP4RouteProperty {
        NEXTHOP,
        METRIC1;

    }

    static enum NetRouteProperty {
        NEXTHOP,
        ROUTEMETRIC;

    }
}

