/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private static final WmiUtil.WmiQuery<CsProductProperty> IDENTIFYINGNUMBER_QUERY = WmiUtil.createQuery("Win32_Csproduct", CsProductProperty.class);
    private String systemSerialNumber = "";

    WindowsComputerSystem() {
        this.init();
    }

    private void init() {
        WmiUtil.WmiQuery<ComputerSystemProperty> computerSystemQuery = WmiUtil.createQuery("Win32_ComputerSystem", ComputerSystemProperty.class);
        WmiUtil.WmiResult<ComputerSystemProperty> win32ComputerSystem = WmiUtil.queryWMI(computerSystemQuery);
        if (win32ComputerSystem.getResultCount() > 0) {
            this.setManufacturer(win32ComputerSystem.getString(ComputerSystemProperty.MANUFACTURER, 0));
            this.setModel(win32ComputerSystem.getString(ComputerSystemProperty.MODEL, 0));
        }
        this.setSerialNumber(this.getSystemSerialNumber());
        this.setFirmware(new WindowsFirmware());
        this.setBaseboard(new WindowsBaseboard());
    }

    private String getSystemSerialNumber() {
        WmiUtil.WmiResult<CsProductProperty> identifyingNumber;
        if (!"".equals(this.systemSerialNumber)) {
            return this.systemSerialNumber;
        }
        WmiUtil.WmiQuery<BiosProperty> serialNumberQuery = WmiUtil.createQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WmiUtil.WmiResult<BiosProperty> serialNumber = WmiUtil.queryWMI(serialNumberQuery);
        if (serialNumber.getResultCount() > 0) {
            this.systemSerialNumber = serialNumber.getString(BiosProperty.SERIALNUMBER, 0);
        }
        if (!"".equals(this.systemSerialNumber) && (identifyingNumber = WmiUtil.queryWMI(IDENTIFYINGNUMBER_QUERY)).getResultCount() > 0) {
            this.systemSerialNumber = identifyingNumber.getString(CsProductProperty.IDENTIFYINGNUMBER, 0);
        }
        if (!"".equals(this.systemSerialNumber)) {
            this.systemSerialNumber = "unknown";
        }
        return this.systemSerialNumber;
    }

    static enum CsProductProperty {
        IDENTIFYINGNUMBER;

    }

    static enum BiosProperty {
        SERIALNUMBER;

    }

    static enum ComputerSystemProperty {
        MANUFACTURER,
        MODEL;

    }
}

