/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Sensors;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);
    private static final String BASE_SENSOR_CLASS = "Sensor";
    private static final WmiUtil.WmiQuery<OhmHardwareProperty> OHM_HARDWARE_QUERY = WmiUtil.createQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE HardwareType=\"CPU\"", OhmHardwareProperty.class);
    private static final WmiUtil.WmiQuery<OhmHardwareProperty> OHM_VOLTAGE_QUERY = WmiUtil.createQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE SensorType=\"Voltage\"", OhmHardwareProperty.class);
    private static final WmiUtil.WmiQuery<OhmSensorProperty> OHM_SENSOR_QUERY = WmiUtil.createQuery("ROOT\\OpenHardwareMonitor", null, OhmSensorProperty.class);
    private static final WmiUtil.WmiQuery<ThermalZoneProperty> THERMAL_ZONE_QUERY = WmiUtil.createQuery("ROOT\\CIMV2", "Win32_PerfRawData_Counters_ThermalZoneInformation", ThermalZoneProperty.class);
    private static final WmiUtil.WmiQuery<FanProperty> FAN_QUERY = WmiUtil.createQuery("Win32_Fan", FanProperty.class);
    private static final WmiUtil.WmiQuery<VoltProperty> VOLT_QUERY = WmiUtil.createQuery("Win32_Processor", VoltProperty.class);

    @Override
    public double getCpuTemperature() {
        String cpuIdentifier;
        double tempC = 0.0;
        WmiUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_HARDWARE_QUERY);
        if (ohmHardware.getResultCount() > 0 && (cpuIdentifier = (String)ohmHardware.get(OhmHardwareProperty.IDENTIFIER).get(0)).length() > 0) {
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(cpuIdentifier);
            sb.append("\" AND SensorType=\"Temperature\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WmiUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                double sum = 0.0;
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    sum += (double)((Float)ohmSensors.get(OhmSensorProperty.VALUE).get(i)).floatValue();
                }
                tempC = sum / (double)ohmSensors.getResultCount();
            }
            return tempC;
        }
        try {
            long tempK = 0L;
            WmiUtil.WmiResult<ThermalZoneProperty> thermalZone = WmiUtil.queryWMI(THERMAL_ZONE_QUERY, 2000);
            if (thermalZone.getResultCount() > 0) {
                tempK = (Long)thermalZone.get(ThermalZoneProperty.TEMPERATURE).get(0);
                if (thermalZone.getResultCount() > 1) {
                    for (int i = 0; i < thermalZone.getResultCount(); ++i) {
                        if (!((String)thermalZone.get(ThermalZoneProperty.NAME).get(i)).toLowerCase().contains("cpu")) continue;
                        tempK = (Long)thermalZone.get(ThermalZoneProperty.TEMPERATURE).get(i);
                        break;
                    }
                }
            }
            if (tempK > 2732L) {
                tempC = (double)tempK / 10.0 - 273.15;
            } else if (tempK > 274L) {
                tempC = (double)tempK - 273.0;
            }
        }
        catch (TimeoutException e) {
            LOG.warn("Temperature query timed out. {}", (Object)e.getMessage());
            return 0.0;
        }
        if (tempC < 0.0) {
            tempC = 0.0;
        }
        return tempC;
    }

    @Override
    public int[] getFanSpeeds() {
        WmiUtil.WmiResult<FanProperty> fan;
        String cpuIdentifier;
        WmiUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_HARDWARE_QUERY);
        if (ohmHardware.getResultCount() > 0 && (cpuIdentifier = (String)ohmHardware.get(OhmHardwareProperty.IDENTIFIER).get(0)).length() > 0) {
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(cpuIdentifier);
            sb.append("\" AND SensorType=\"Fan\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WmiUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    fanSpeeds[i] = ((Float)ohmSensors.get(OhmSensorProperty.VALUE).get(i)).intValue();
                }
                return fanSpeeds;
            }
        }
        if ((fan = WmiUtil.queryWMI(FAN_QUERY)).getResultCount() > 1) {
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i = 0; i < fan.getResultCount(); ++i) {
                fanSpeeds[i] = ((Long)fan.get(FanProperty.DESIREDSPEED).get(i)).intValue();
            }
            return fanSpeeds;
        }
        return new int[1];
    }

    @Override
    public double getCpuVoltage() {
        int decivolts;
        WmiUtil.WmiResult<VoltProperty> voltage;
        WmiUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_VOLTAGE_QUERY);
        if (ohmHardware.getResultCount() > 0) {
            String voltIdentifierStr = null;
            for (int i = 0; i < ohmHardware.getResultCount(); ++i) {
                String id = (String)ohmHardware.get(OhmHardwareProperty.IDENTIFIER).get(i);
                if (!id.toLowerCase().contains("cpu")) continue;
                voltIdentifierStr = id;
                break;
            }
            if (voltIdentifierStr == null) {
                voltIdentifierStr = (String)ohmHardware.get(OhmHardwareProperty.IDENTIFIER).get(0);
            }
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(voltIdentifierStr);
            sb.append("\" AND SensorType=\"Voltage\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WmiUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                return ((Float)ohmSensors.get(OhmSensorProperty.VALUE).get(0)).doubleValue();
            }
        }
        if ((voltage = WmiUtil.queryWMI(VOLT_QUERY)).getResultCount() > 1 && (decivolts = ((Long)voltage.get(VoltProperty.CURRENTVOLTAGE).get(0)).intValue()) > 0) {
            if ((decivolts & 0x80) == 0) {
                decivolts = ((Long)voltage.get(VoltProperty.VOLTAGECAPS).get(0)).intValue();
                if ((decivolts & 1) > 0) {
                    return 5.0;
                }
                if ((decivolts & 2) > 0) {
                    return 3.3;
                }
                if ((decivolts & 4) > 0) {
                    return 2.9;
                }
            } else {
                return (double)(decivolts & 0x7F) / 10.0;
            }
        }
        return 0.0;
    }

    static enum VoltProperty implements WmiUtil.WmiProperty
    {
        CURRENTVOLTAGE(WmiUtil.ValueType.UINT32),
        VOLTAGECAPS(WmiUtil.ValueType.UINT32);

        private WmiUtil.ValueType type;

        private VoltProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum FanProperty implements WmiUtil.WmiProperty
    {
        DESIREDSPEED(WmiUtil.ValueType.UINT32);

        private WmiUtil.ValueType type;

        private FanProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum ThermalZoneProperty implements WmiUtil.WmiProperty
    {
        NAME(WmiUtil.ValueType.STRING),
        TEMPERATURE(WmiUtil.ValueType.UINT32);

        private WmiUtil.ValueType type;

        private ThermalZoneProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum OhmSensorProperty implements WmiUtil.WmiProperty
    {
        VALUE(WmiUtil.ValueType.FLOAT);

        private WmiUtil.ValueType type;

        private OhmSensorProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum OhmHardwareProperty implements WmiUtil.WmiProperty
    {
        IDENTIFIER(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private OhmHardwareProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }
}

