/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.common.AbstractBaseboard;
import oshi.util.platform.windows.WmiUtil;

public class WindowsBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;

    WindowsBaseboard() {
        this.init();
    }

    private void init() {
        WmiUtil.WmiQuery<BaseboardProperty> baseboardQuery = WmiUtil.createQuery("Win32_BaseBoard", BaseboardProperty.class);
        WmiUtil.WmiResult<BaseboardProperty> win32BaseBoard = WmiUtil.queryWMI(baseboardQuery);
        if (win32BaseBoard.getResultCount() > 0) {
            this.setManufacturer((String)win32BaseBoard.get(BaseboardProperty.MANUFACTURER).get(0));
            this.setModel((String)win32BaseBoard.get(BaseboardProperty.MODEL).get(0));
            this.setVersion((String)win32BaseBoard.get(BaseboardProperty.VERSION).get(0));
            this.setSerialNumber((String)win32BaseBoard.get(BaseboardProperty.SERIALNUMBER).get(0));
        }
    }

    static enum BaseboardProperty implements WmiUtil.WmiProperty
    {
        MANUFACTURER(WmiUtil.ValueType.STRING),
        MODEL(WmiUtil.ValueType.STRING),
        VERSION(WmiUtil.ValueType.STRING),
        SERIALNUMBER(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private BaseboardProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }
}

