/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.json.hardware.Baseboard;
import oshi.json.hardware.ComputerSystem;
import oshi.json.hardware.Firmware;
import oshi.json.hardware.impl.BaseboardImpl;
import oshi.json.hardware.impl.FirmwareImpl;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class ComputerSystemImpl
extends AbstractOshiJsonObject
implements ComputerSystem {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.ComputerSystem computerSystem;

    public ComputerSystemImpl(oshi.hardware.ComputerSystem computerSystem) {
        this.computerSystem = computerSystem;
    }

    @Override
    public String getManufacturer() {
        return this.computerSystem.getManufacturer();
    }

    @Override
    public String getModel() {
        return this.computerSystem.getModel();
    }

    @Override
    public String getSerialNumber() {
        return this.computerSystem.getSerialNumber();
    }

    @Override
    public Firmware getFirmware() {
        return new FirmwareImpl(this.computerSystem.getFirmware());
    }

    @Override
    public Baseboard getBaseboard() {
        return new BaseboardImpl(this.computerSystem.getBaseboard());
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.manufacturer")) {
            json.add("manufacturer", this.getManufacturer());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.model")) {
            json.add("model", this.getModel());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.serialNumber")) {
            json.add("serialNumber", this.getSerialNumber());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.firmware")) {
            json.add("firmware", (JsonValue)this.getFirmware().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.baseboard")) {
            json.add("baseboard", (JsonValue)this.getBaseboard().toJSON(properties));
        }
        return json.build();
    }

    @Override
    public String toString() {
        return this.computerSystem.toString();
    }
}

