/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import java.util.Arrays;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

public class ComputerID {
    public static final List<String> NON_UNIQUE_UUIDS = Arrays.asList("03000200-0400-0500-0006-000700080009", "FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF", "00000000-0000-0000-0000-000000000000");

    public static void main(String[] args) {
        String unknownHash = String.format("%08x", "unknown".hashCode());
        System.out.println("Here's a unique (?) id for your computer.");
        System.out.println(ComputerID.getComputerIdentifier());
        System.out.println("If any field is " + unknownHash + " then I couldn't find a serial number or unique uuid, and running as sudo might change this.");
    }

    public static String getComputerIdentifier() {
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
        CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
        ComputerSystem computerSystem = hardwareAbstractionLayer.getComputerSystem();
        String vendor = operatingSystem.getManufacturer();
        String processorSerialNumber = computerSystem.getSerialNumber();
        String uuid = computerSystem.getHardwareUUID();
        if (NON_UNIQUE_UUIDS.contains(uuid.toUpperCase())) {
            uuid = "unknown";
        }
        String processorIdentifier = centralProcessor.getProcessorIdentifier().getIdentifier();
        int processors = centralProcessor.getLogicalProcessorCount();
        String delimiter = "-";
        return String.format("%08x", vendor.hashCode()) + delimiter + String.format("%08x", processorSerialNumber.hashCode()) + delimiter + String.format("%08x", uuid.hashCode()) + delimiter + String.format("%08x", processorIdentifier.hashCode()) + delimiter + processors;
    }
}

