/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import com.sun.jna.platform.win32.COM.COMException;
import oshi.demo.WmiNoComInitQueryHandler;
import oshi.driver.windows.wmi.Win32OperatingSystem;
import oshi.util.platform.windows.WmiQueryHandler;

public class UserComInit {
    private static final int REPETITIONS = 300;

    public static void main(String[] args) {
        UserComInit.wakeUpCom();
        System.out.println("Collecting statistics with default COM setup");
        UserComInit.loopWmiQueries();
        System.out.println("Collecting statistics with user-init COM setup");
        UserComInit.loopWmiQueriesWithUserCom();
    }

    private static void wakeUpCom() {
        Win32OperatingSystem.queryOsVersion();
    }

    private static void loopWmiQueries() {
        long t = System.nanoTime();
        for (int i = 0; i < 300; ++i) {
            Win32OperatingSystem.queryOsVersion();
        }
        t = System.nanoTime() - t;
        System.out.println("Average ms per rep: " + (double)t / 3.0E8);
    }

    private static void loopWmiQueriesWithUserCom() {
        WmiQueryHandler handler = WmiQueryHandler.createInstance();
        WmiQueryHandler.setInstanceClass(WmiNoComInitQueryHandler.class);
        boolean comInit = false;
        try {
            comInit = handler.initCOM();
            UserComInit.loopWmiQueries();
        }
        catch (COMException cOMException) {
            // empty catch block
        }
        if (comInit) {
            handler.unInitCOM();
        }
    }
}

