/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.common.AbstractHWDiskStore;
import oshi.jna.platform.linux.Udev;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
public final class LinuxHWDiskStore
extends AbstractHWDiskStore {
    private static final int SECTORSIZE = 512;
    private static final int[] UDEV_STAT_ORDERS = new int[UdevStat.values().length];
    private static final int UDEV_STAT_LENGTH;
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private long timeStamp = 0L;
    private List<HWPartition> partitionList;

    private LinuxHWDiskStore(String name, String model, String serial, long size) {
        super(name, model, serial, size);
    }

    @Override
    public long getReads() {
        return this.reads;
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getWrites() {
        return this.writes;
    }

    @Override
    public long getWriteBytes() {
        return this.writeBytes;
    }

    @Override
    public long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    @Override
    public long getTransferTime() {
        return this.transferTime;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public List<HWPartition> getPartitions() {
        return this.partitionList;
    }

    public static List<HWDiskStore> getDisks() {
        return Collections.unmodifiableList(LinuxHWDiskStore.getDisks(null));
    }

    private static List<LinuxHWDiskStore> getDisks(LinuxHWDiskStore storeToUpdate) {
        Udev.UdevDevice device;
        LinuxHWDiskStore store = null;
        ArrayList<LinuxHWDiskStore> result = new ArrayList<LinuxHWDiskStore>();
        Map<String, String> mountsMap = LinuxHWDiskStore.readMountsMap();
        Udev.UdevHandle handle = Udev.INSTANCE.udev_new();
        Udev.UdevEnumerate enumerate = Udev.INSTANCE.udev_enumerate_new(handle);
        Udev.INSTANCE.udev_enumerate_add_match_subsystem(enumerate, "block");
        Udev.INSTANCE.udev_enumerate_scan_devices(enumerate);
        Udev.UdevListEntry entry = Udev.INSTANCE.udev_enumerate_get_list_entry(enumerate);
        while ((device = Udev.INSTANCE.udev_device_new_from_syspath(handle, Udev.INSTANCE.udev_list_entry_get_name(entry))) != null) {
            String devnode = Udev.INSTANCE.udev_device_get_devnode(device);
            if (devnode != null && !devnode.startsWith("/dev/loop") && !devnode.startsWith("/dev/ram")) {
                if ("disk".equals(Udev.INSTANCE.udev_device_get_devtype(device))) {
                    String devModel = Udev.INSTANCE.udev_device_get_property_value(device, "ID_MODEL");
                    String devSerial = Udev.INSTANCE.udev_device_get_property_value(device, "ID_SERIAL_SHORT");
                    long devSize = ParseUtil.parseLongOrDefault(Udev.INSTANCE.udev_device_get_sysattr_value(device, "size"), 0L) * 512L;
                    store = new LinuxHWDiskStore(devnode, devModel == null ? "unknown" : devModel, devSerial == null ? "unknown" : devSerial, devSize);
                    if (storeToUpdate == null) {
                        store.partitionList = new ArrayList<HWPartition>();
                        LinuxHWDiskStore.computeDiskStats(store, device);
                        result.add(store);
                    } else if (store.getName().equals(storeToUpdate.getName()) && store.getModel().equals(storeToUpdate.getModel()) && store.getSerial().equals(storeToUpdate.getSerial()) && store.getSize() == storeToUpdate.getSize()) {
                        LinuxHWDiskStore.computeDiskStats(storeToUpdate, device);
                        result.add(storeToUpdate);
                        Udev.INSTANCE.udev_device_unref(device);
                        break;
                    }
                } else if ("partition".equals(Udev.INSTANCE.udev_device_get_devtype(device)) && store != null) {
                    String name = Udev.INSTANCE.udev_device_get_devnode(device);
                    store.partitionList.add(new HWPartition(name, Udev.INSTANCE.udev_device_get_sysname(device), Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_TYPE") == null ? "partition" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_TYPE"), Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_UUID") == null ? "" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_UUID"), ParseUtil.parseLongOrDefault(Udev.INSTANCE.udev_device_get_sysattr_value(device, "size"), 0L) * 512L, ParseUtil.parseIntOrDefault(Udev.INSTANCE.udev_device_get_property_value(device, "MAJOR"), 0), ParseUtil.parseIntOrDefault(Udev.INSTANCE.udev_device_get_property_value(device, "MINOR"), 0), mountsMap.getOrDefault(name, "")));
                }
            }
            Udev.INSTANCE.udev_device_unref(device);
            entry = Udev.INSTANCE.udev_list_entry_get_next(entry);
        }
        Udev.INSTANCE.udev_enumerate_unref(enumerate);
        Udev.INSTANCE.udev_unref(handle);
        for (LinuxHWDiskStore hwds : result) {
            hwds.partitionList = Collections.unmodifiableList(hwds.partitionList.stream().sorted(Comparator.comparing(HWPartition::getName)).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public boolean updateAttributes() {
        return !LinuxHWDiskStore.getDisks(this).isEmpty();
    }

    private static Map<String, String> readMountsMap() {
        HashMap<String, String> mountsMap = new HashMap<String, String>();
        List<String> mounts = FileUtil.readFile(ProcPath.MOUNTS);
        for (String mount : mounts) {
            String[] split = ParseUtil.whitespaces.split(mount);
            if (split.length < 2 || !split[0].startsWith("/dev/")) continue;
            mountsMap.put(split[0], split[1]);
        }
        return mountsMap;
    }

    private static void computeDiskStats(LinuxHWDiskStore store, Udev.UdevDevice disk) {
        String devstat = Udev.INSTANCE.udev_device_get_sysattr_value(disk, "stat");
        long[] devstatArray = ParseUtil.parseStringToLongArray(devstat, UDEV_STAT_ORDERS, UDEV_STAT_LENGTH, ' ');
        store.timeStamp = System.currentTimeMillis();
        store.reads = devstatArray[UdevStat.READS.ordinal()];
        store.readBytes = devstatArray[UdevStat.READ_BYTES.ordinal()] * 512L;
        store.writes = devstatArray[UdevStat.WRITES.ordinal()];
        store.writeBytes = devstatArray[UdevStat.WRITE_BYTES.ordinal()] * 512L;
        store.currentQueueLength = devstatArray[UdevStat.QUEUE_LENGTH.ordinal()];
        store.transferTime = devstatArray[UdevStat.ACTIVE_MS.ordinal()];
    }

    static {
        for (UdevStat stat : UdevStat.values()) {
            LinuxHWDiskStore.UDEV_STAT_ORDERS[stat.ordinal()] = stat.getOrder();
        }
        String stat = FileUtil.getStringFromFile(ProcPath.DISKSTATS);
        int statLength = 11;
        if (!stat.isEmpty()) {
            statLength = ParseUtil.countStringToLongArray(stat, ' ');
        }
        UDEV_STAT_LENGTH = statLength;
    }

    static enum UdevStat {
        READS(0),
        READ_BYTES(2),
        WRITES(4),
        WRITE_BYTES(6),
        QUEUE_LENGTH(8),
        ACTIVE_MS(9);

        private int order;

        public int getOrder() {
            return this.order;
        }

        private UdevStat(int order) {
            this.order = order;
        }
    }
}

