/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import com.sun.jna.win32.W32APITypeMapper;
import java.util.Map;
import oshi.jna.platform.windows.WinNT;

public interface Wtsapi32
extends com.sun.jna.platform.win32.Wtsapi32 {
    public static final Wtsapi32 INSTANCE = (Wtsapi32)Native.load((String)"Wtsapi32", Wtsapi32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    public static final int DOMAIN_LENGTH = 17;
    public static final int USERNAME_LENGTH = 20;
    public static final int WINSTATIONNAME_LENGTH = 32;

    public boolean WTSEnumerateSessions(WinNT.HANDLE var1, int var2, int var3, PointerByReference var4, IntByReference var5);

    public boolean WTSQuerySessionInformation(WinNT.HANDLE var1, int var2, int var3, PointerByReference var4, IntByReference var5);

    public void WTSFreeMemory(Pointer var1);

    @Structure.FieldOrder(value={"State", "SessionId", "IncomingBytes", "OutgoingBytes", "IncomingFrames", "OutgoingFrames", "IncomingCompressedBytes", "OutgoingCompressedBytes", "WinStationName", "Domain", "UserName", "ConnectTime", "DisconnectTime", "LastInputTime", "LogonTime", "CurrentTime"})
    public static class WTSINFO
    extends Structure {
        private static final int CHAR_WIDTH = Boolean.getBoolean("w32.ascii") ? 1 : 2;
        public int State;
        public int SessionId;
        public int IncomingBytes;
        public int OutgoingBytes;
        public int IncomingFrames;
        public int OutgoingFrames;
        public int IncomingCompressedBytes;
        public int OutgoingCompressedBytes;
        public byte[] WinStationName = new byte[32 * CHAR_WIDTH];
        public byte[] Domain = new byte[17 * CHAR_WIDTH];
        public byte[] UserName = new byte[21 * CHAR_WIDTH];
        public WinNT.LARGE_INTEGER ConnectTime;
        public WinNT.LARGE_INTEGER DisconnectTime;
        public WinNT.LARGE_INTEGER LastInputTime;
        public WinNT.LARGE_INTEGER LogonTime;
        public WinNT.LARGE_INTEGER CurrentTime;

        public WTSINFO() {
            super(W32APITypeMapper.DEFAULT);
        }

        public WTSINFO(Pointer p) {
            super(p, 0, W32APITypeMapper.DEFAULT);
            this.read();
        }

        public String getWinStationName() {
            return this.getStringAtOffset(this.fieldOffset("WinStationName"));
        }

        public String getDomain() {
            return this.getStringAtOffset(this.fieldOffset("Domain"));
        }

        public String getUserName() {
            return this.getStringAtOffset(this.fieldOffset("UserName"));
        }

        private String getStringAtOffset(int offset) {
            return CHAR_WIDTH == 1 ? this.getPointer().getString((long)offset) : this.getPointer().getWideString((long)offset);
        }
    }

    @Structure.FieldOrder(value={"AddressFamily", "Address"})
    public static class WTS_CLIENT_ADDRESS
    extends Structure {
        public int AddressFamily;
        public byte[] Address = new byte[20];

        public WTS_CLIENT_ADDRESS() {
        }

        public WTS_CLIENT_ADDRESS(Pointer p) {
            super(p);
            this.read();
        }
    }

    @Structure.FieldOrder(value={"SessionId", "pWinStationName", "State"})
    public static class WTS_SESSION_INFO
    extends Structure {
        public int SessionId;
        public String pWinStationName;
        public int State;

        public WTS_SESSION_INFO() {
            super(W32APITypeMapper.DEFAULT);
        }

        public WTS_SESSION_INFO(Pointer p) {
            super(p, 0, W32APITypeMapper.DEFAULT);
            this.read();
        }
    }
}

