/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

@Immutable
final class LinuxFirmware
extends AbstractFirmware {
    private static final DateTimeFormatter VCGEN_FORMATTER = DateTimeFormatter.ofPattern("MMM d uuuu HH:mm:ss", Locale.ENGLISH);
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<String> description = Memoizer.memoize(this::queryDescription);
    private final Supplier<String> version = Memoizer.memoize(this::queryVersion);
    private final Supplier<String> releaseDate = Memoizer.memoize(this::queryReleaseDate);
    private final Supplier<String> name = Memoizer.memoize(this::queryName);
    private final Supplier<VcGenCmdStrings> vcGenCmd = Memoizer.memoize(this::queryVcGenCmd);
    private final Supplier<BiosStrings> bios = Memoizer.memoize(this::queryBios);

    LinuxFirmware() {
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getDescription() {
        return this.description.get();
    }

    @Override
    public String getVersion() {
        return this.version.get();
    }

    @Override
    public String getReleaseDate() {
        return this.releaseDate.get();
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    private String queryManufacturer() {
        String result = null;
        result = LinuxFirmware.queryManufacturerFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().manufacturer) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryDescription() {
        String result = null;
        result = LinuxFirmware.queryDescriptionFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().description) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryVersion() {
        String result = null;
        result = this.queryVersionFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().version) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryReleaseDate() {
        String result = null;
        result = LinuxFirmware.queryReleaseDateFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().releaseDate) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryName() {
        String result = null;
        result = this.bios.get().biosName;
        if (result == null && (result = this.vcGenCmd.get().name) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryManufacturerFromSysfs() {
        String biosVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_vendor").trim();
        if (biosVendor.isEmpty()) {
            return biosVendor;
        }
        return null;
    }

    private static String queryDescriptionFromSysfs() {
        String modalias = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/modalias").trim();
        if (!modalias.isEmpty()) {
            return modalias;
        }
        return null;
    }

    private String queryVersionFromSysfs() {
        String biosVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_version").trim();
        if (!biosVersion.isEmpty()) {
            String biosRevision = this.bios.get().biosRevision;
            return biosVersion + (Util.isBlank(biosRevision) ? "" : " (revision " + biosRevision + ")");
        }
        return null;
    }

    private static String queryReleaseDateFromSysfs() {
        String biosDate = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_date").trim();
        if (!biosDate.isEmpty()) {
            return ParseUtil.parseMmDdYyyyToYyyyMmDD(biosDate);
        }
        return null;
    }

    private BiosStrings queryBios() {
        String biosName = null;
        String revision = null;
        String biosMarker = "SMBIOS";
        String revMarker = "Bios Revision:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
            String[] biosArr;
            if (checkLine.contains("SMBIOS") && (biosArr = ParseUtil.whitespaces.split(checkLine)).length >= 2) {
                biosName = biosArr[0] + " " + biosArr[1];
            }
            if (!checkLine.contains("Bios Revision:")) continue;
            revision = checkLine.split("Bios Revision:")[1].trim();
            break;
        }
        return new BiosStrings(biosName, revision);
    }

    private VcGenCmdStrings queryVcGenCmd() {
        String vcReleaseDate = null;
        String vcManufacturer = null;
        String vcVersion = null;
        List<String> vcgencmd = ExecutingCommand.runNative("vcgencmd version");
        if (vcgencmd.size() >= 3) {
            try {
                vcReleaseDate = DateTimeFormatter.ISO_LOCAL_DATE.format(VCGEN_FORMATTER.parse(vcgencmd.get(0)));
            }
            catch (DateTimeParseException e) {
                vcReleaseDate = "unknown";
            }
            String[] copyright = ParseUtil.whitespaces.split(vcgencmd.get(1));
            vcManufacturer = copyright[copyright.length - 1];
            vcVersion = vcgencmd.get(2).replace("version ", "");
            return new VcGenCmdStrings(vcReleaseDate, vcManufacturer, vcVersion, "RPi", "Bootloader");
        }
        return new VcGenCmdStrings(null, null, null, null, null);
    }

    private static final class VcGenCmdStrings {
        private final String releaseDate;
        private final String manufacturer;
        private final String version;
        private final String name;
        private final String description;

        private VcGenCmdStrings(String releaseDate, String manufacturer, String version, String name, String description) {
            this.releaseDate = releaseDate;
            this.manufacturer = manufacturer;
            this.version = version;
            this.name = name;
            this.description = description;
        }
    }

    private static final class BiosStrings {
        private final String biosName;
        private final String biosRevision;

        private BiosStrings(String biosName, String biosRevision) {
            this.biosName = biosName;
            this.biosRevision = biosRevision;
        }
    }
}

