/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.perfmon;

import java.util.List;
import java.util.Map;
import oshi.util.platform.windows.PerfCounterWildcardQuery;
import oshi.util.tuples.Pair;

public class PhysicalDisk {
    private static final String PHYSICAL_DISK = "PhysicalDisk";
    private static final String WIN32_PERF_RAW_DATA_PERF_DISK_PHYSICAL_DISK_WHERE_NOT_NAME_TOTAL = "Win32_PerfRawData_PerfDisk_PhysicalDisk WHERE NOT Name=\"_Total\"";

    public Pair<List<String>, Map<PhysicalDiskProperty, List<Long>>> queryDiskCounters() {
        PerfCounterWildcardQuery<PhysicalDiskProperty> physicalDiskPerfCounters = new PerfCounterWildcardQuery<PhysicalDiskProperty>(PhysicalDiskProperty.class, PHYSICAL_DISK, WIN32_PERF_RAW_DATA_PERF_DISK_PHYSICAL_DISK_WHERE_NOT_NAME_TOTAL);
        Map<PhysicalDiskProperty, List<Long>> values = physicalDiskPerfCounters.queryValuesWildcard();
        List<String> instances = physicalDiskPerfCounters.getInstancesFromLastQuery();
        return new Pair<List<String>, Map<PhysicalDiskProperty, List<Long>>>(instances, values);
    }

    public static enum PhysicalDiskProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("^_Total"),
        DISKREADSPERSEC("Disk Reads/sec"),
        DISKREADBYTESPERSEC("Disk Read Bytes/sec"),
        DISKWRITESPERSEC("Disk Writes/sec"),
        DISKWRITEBYTESPERSEC("Disk Write Bytes/sec"),
        CURRENTDISKQUEUELENGTH("Current Disk Queue Length"),
        PERCENTIDLETIME("% Idle Time");

        private final String counter;

        private PhysicalDiskProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

