/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.ParseUtil;

public final class GlobalConfig {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfig.class);
    private static final Properties configuration = new Properties();

    public static String get(String key, String def) {
        return configuration.getProperty(key, def);
    }

    public static int get(String key, int def) {
        String value = configuration.getProperty(key);
        return value == null ? def : ParseUtil.parseIntOrDefault(value, def);
    }

    public static double get(String key, double def) {
        String value = configuration.getProperty(key);
        return value == null ? def : ParseUtil.parseDoubleOrDefault(value, def);
    }

    public static boolean get(String key, boolean def) {
        String value = configuration.getProperty(key);
        return value == null ? def : Boolean.parseBoolean(value);
    }

    public static void set(String key, Object val) {
        if (val == null) {
            configuration.remove(key);
        } else {
            configuration.setProperty(key, val.toString());
        }
    }

    public static void remove(String key) {
        configuration.remove(key);
    }

    public static void clear() {
        configuration.clear();
    }

    public static void load(Properties properties) {
        configuration.putAll((Map<?, ?>)properties);
    }

    private GlobalConfig() {
    }

    static {
        try (InputStream in = GlobalConfig.class.getResourceAsStream("/default.properties");){
            if (in != null) {
                configuration.load(in);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to load default configuration");
        }
    }

    public static class PropertyException
    extends RuntimeException {
        private static final long serialVersionUID = -7482581936621748005L;

        public PropertyException(String property) {
            super("Invalid property: \"" + property + "\" = " + GlobalConfig.get(property, null));
        }

        public PropertyException(String property, String message) {
            super("Invalid property \"" + property + "\": " + message);
        }
    }
}

