/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.windows.WindowsVirtualMemory;

public class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);

    @Override
    public long getAvailable() {
        this.updatePerfInfo();
        return this.memAvailable;
    }

    @Override
    public long getTotal() {
        if (this.memTotal < 0L) {
            this.updatePerfInfo();
        }
        return this.memTotal;
    }

    @Override
    public long getPageSize() {
        if (this.pageSize < 0L) {
            this.updatePerfInfo();
        }
        return this.pageSize;
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        if (this.virtualMemory == null) {
            this.virtualMemory = new WindowsVirtualMemory(this.getPageSize());
        }
        return this.virtualMemory;
    }

    private void updatePerfInfo() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return;
        }
        this.pageSize = perfInfo.PageSize.longValue();
        this.memAvailable = this.pageSize * perfInfo.PhysicalAvailable.longValue();
        this.memTotal = this.pageSize * perfInfo.PhysicalTotal.longValue();
    }
}

