/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.solaris.SolarisBaseboard;
import oshi.hardware.platform.unix.solaris.SolarisFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

final class SolarisComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;

    SolarisComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.readSmbios();
        }
        return this.manufacturer;
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.readSmbios();
        }
        return this.model;
    }

    @Override
    public String getSerialNumber() {
        if (this.serialNumber == null) {
            this.serialNumber = this.getSystemSerialNumber();
        }
        return this.serialNumber;
    }

    @Override
    public Firmware getFirmware() {
        if (this.firmware == null) {
            this.firmware = new SolarisFirmware();
        }
        return this.firmware;
    }

    @Override
    public Baseboard getBaseboard() {
        if (this.baseboard == null) {
            this.baseboard = new SolarisBaseboard();
        }
        return this.baseboard;
    }

    private void readSmbios() {
        int smbTypeId = -1;
        for (String checkLine : ExecutingCommand.runNative("smbios")) {
            if (checkLine.contains("SMB_TYPE_")) {
                if (checkLine.contains("SMB_TYPE_BIOS")) {
                    smbTypeId = 0;
                } else if (checkLine.contains("SMB_TYPE_SYSTEM")) {
                    smbTypeId = 1;
                } else {
                    if (!checkLine.contains("SMB_TYPE_BASEBOARD")) break;
                    smbTypeId = 2;
                }
            }
            switch (smbTypeId) {
                case 0: {
                    this.setFirmwareAttributes(checkLine);
                    break;
                }
                case 1: {
                    this.setComputerSystemAttributes(checkLine);
                    break;
                }
                case 2: {
                    this.setBaseboardAttributes(checkLine);
                    break;
                }
            }
        }
    }

    private void setComputerSystemAttributes(String checkLine) {
        String manufacturerMarker = "Manufacturer:";
        String productMarker = "Product:";
        String serialNumMarker = "Serial Number:";
        if (checkLine.contains("Manufacturer:")) {
            String manufacturer = checkLine.split("Manufacturer:")[1].trim();
            if (!manufacturer.isEmpty()) {
                this.manufacturer = manufacturer;
            }
        } else if (checkLine.contains("Product:")) {
            String product = checkLine.split("Product:")[1].trim();
            if (!product.isEmpty()) {
                this.model = product;
            }
        } else if (checkLine.contains("Serial Number:")) {
            this.serialNumber = checkLine.split("Serial Number:")[1].trim();
        }
    }

    private void setFirmwareAttributes(String checkLine) {
        String biosDate;
        String vendorMarker = "Vendor:";
        String biosDateMarker = "Release Date:";
        String biosVersionMarker = "VersionString:";
        if (checkLine.contains("Vendor:")) {
            String vendor = checkLine.split("Vendor:")[1].trim();
            if (!vendor.isEmpty()) {
                ((SolarisFirmware)this.getFirmware()).setManufacturer(vendor);
            }
        } else if (checkLine.contains("VersionString:")) {
            String biosVersion = checkLine.split("VersionString:")[1].trim();
            if (!biosVersion.isEmpty()) {
                ((SolarisFirmware)this.getFirmware()).setVersion(biosVersion);
            }
        } else if (checkLine.contains("Release Date:") && !(biosDate = checkLine.split("Release Date:")[1].trim()).isEmpty()) {
            ((SolarisFirmware)this.getFirmware()).setReleaseDate(ParseUtil.parseMmDdYyyyToYyyyMmDD(biosDate));
        }
    }

    private void setBaseboardAttributes(String checkLine) {
        String boardSerialNumber;
        String manufacturerMarker = "Manufacturer:";
        String productMarker = "Product:";
        String versionMarker = "Version:";
        String serialNumMarker = "Serial Number:";
        if (checkLine.contains("Manufacturer:")) {
            String boardManufacturer = checkLine.split("Manufacturer:")[1].trim();
            if (!boardManufacturer.isEmpty()) {
                ((SolarisBaseboard)this.getBaseboard()).setManufacturer(boardManufacturer);
            }
        } else if (checkLine.contains("Product:")) {
            String product = checkLine.split("Product:")[1].trim();
            if (!product.isEmpty()) {
                ((SolarisBaseboard)this.getBaseboard()).setModel(product);
            }
        } else if (checkLine.contains("Version:")) {
            String version = checkLine.split("Version:")[1].trim();
            if (!version.isEmpty()) {
                ((SolarisBaseboard)this.getBaseboard()).setVersion(version);
            }
        } else if (checkLine.contains("Serial Number:") && !(boardSerialNumber = checkLine.split("Serial Number:")[1].trim()).isEmpty()) {
            ((SolarisBaseboard)this.getBaseboard()).setSerialNumber(boardSerialNumber);
        }
    }

    private String getSystemSerialNumber() {
        String serialNumber = ExecutingCommand.getFirstAnswer("sneep");
        if (serialNumber.isEmpty()) {
            String marker = "chassis-sn:";
            for (String checkLine : ExecutingCommand.runNative("prtconf -pv")) {
                if (!checkLine.contains(marker)) continue;
                serialNumber = ParseUtil.getSingleQuoteStringValue(checkLine);
                break;
            }
        }
        if (serialNumber.isEmpty()) {
            serialNumber = "unknown";
        }
        return serialNumber;
    }
}

