/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.IOKit;
import oshi.util.platform.mac.CfUtil;
import oshi.util.platform.mac.IOKitUtil;

public class MacUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;

    public MacUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, String uniqueDeviceId, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, uniqueDeviceId, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = MacUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            MacUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[0]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(new MacUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), device.getUniqueDeviceId(), new MacUsbDevice[0]));
            MacUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        Memory buffer = new Memory(128L);
        HashMap<Long, String> nameMap = new HashMap<Long, String>();
        HashMap<Long, String> vendorMap = new HashMap<Long, String>();
        HashMap<Long, String> vendorIdMap = new HashMap<Long, String>();
        HashMap<Long, String> productIdMap = new HashMap<Long, String>();
        HashMap<Long, String> serialMap = new HashMap<Long, String>();
        HashMap<Long, List<Long>> hubMap = new HashMap<Long, List<Long>>();
        CoreFoundation.CFStringRef locationIDKey = CoreFoundation.CFStringRef.toCFString("locationID");
        CoreFoundation.CFStringRef ioPropertyMatchKey = CoreFoundation.CFStringRef.toCFString("IOPropertyMatch");
        ArrayList<Long> usbControllers = new ArrayList<Long>();
        IntByReference iter = new IntByReference();
        IOKitUtil.getMatchingServices("IOUSBController", iter);
        int device = IOKit.INSTANCE.IOIteratorNext(iter.getValue());
        while (device != 0) {
            LongByReference id = new LongByReference();
            IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(device, id);
            usbControllers.add(id.getValue());
            IOKit.INSTANCE.IORegistryEntryGetName(device, (Pointer)buffer);
            nameMap.put(id.getValue(), buffer.getString(0L));
            CoreFoundation.CFTypeRef ref = IOKit.INSTANCE.IORegistryEntryCreateCFProperty(device, locationIDKey, CfUtil.ALLOCATOR, 0);
            if (ref != null && ref.getPointer() != null) {
                MacUsbDevice.getControllerIdByLocation(id.getValue(), ref, locationIDKey, ioPropertyMatchKey, vendorIdMap, productIdMap);
            }
            CfUtil.release(ref);
            IntByReference childIter = new IntByReference();
            IOKit.INSTANCE.IORegistryEntryGetChildIterator(device, "IOService", childIter);
            int childDevice = IOKit.INSTANCE.IOIteratorNext(childIter.getValue());
            while (childDevice != 0) {
                String serial;
                long productId;
                long vendorId;
                LongByReference childId = new LongByReference();
                IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(childDevice, childId);
                IntByReference parent = new IntByReference();
                IOKit.INSTANCE.IORegistryEntryGetParentEntry(childDevice, "IOUSB", parent);
                LongByReference parentId = new LongByReference();
                if (!IOKit.INSTANCE.IOObjectConformsTo(parent.getValue(), "IOUSBDevice")) {
                    parentId = id;
                } else {
                    IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(parent.getValue(), parentId);
                }
                hubMap.computeIfAbsent(parentId.getValue(), x -> new ArrayList()).add(childId.getValue());
                IOKit.INSTANCE.IORegistryEntryGetName(childDevice, (Pointer)buffer);
                nameMap.put(childId.getValue(), buffer.getString(0L));
                String vendor = IOKitUtil.getIORegistryStringProperty(childDevice, "USB Vendor Name");
                if (vendor != null) {
                    vendorMap.put(childId.getValue(), vendor);
                }
                if ((vendorId = IOKitUtil.getIORegistryLongProperty(childDevice, "idVendor")) != 0L) {
                    vendorIdMap.put(childId.getValue(), String.format("%04x", 0xFFFFL & vendorId));
                }
                if ((productId = IOKitUtil.getIORegistryLongProperty(childDevice, "idProduct")) != 0L) {
                    productIdMap.put(childId.getValue(), String.format("%04x", 0xFFFFL & productId));
                }
                if ((serial = IOKitUtil.getIORegistryStringProperty(childDevice, "USB Serial Number")) != null) {
                    serialMap.put(childId.getValue(), serial);
                }
                IOKit.INSTANCE.IOObjectRelease(childDevice);
                childDevice = IOKit.INSTANCE.IOIteratorNext(childIter.getValue());
            }
            IOKit.INSTANCE.IOObjectRelease(childIter.getValue());
            IOKit.INSTANCE.IOObjectRelease(device);
            device = IOKit.INSTANCE.IOIteratorNext(iter.getValue());
        }
        IOKit.INSTANCE.IOObjectRelease(iter.getValue());
        CfUtil.release(locationIDKey);
        CfUtil.release(ioPropertyMatchKey);
        ArrayList<MacUsbDevice> controllerDevices = new ArrayList<MacUsbDevice>();
        for (Long controller : usbControllers) {
            controllerDevices.add(MacUsbDevice.getDeviceAndChildren(controller, "0000", "0000", nameMap, vendorMap, vendorIdMap, productIdMap, serialMap, hubMap));
        }
        return controllerDevices.toArray(new UsbDevice[0]);
    }

    private static void getControllerIdByLocation(long id, CoreFoundation.CFTypeRef locationId, CoreFoundation.CFStringRef locationIDKey, CoreFoundation.CFStringRef ioPropertyMatchKey, Map<Long, String> vendorIdMap, Map<Long, String> productIdMap) {
        CoreFoundation.CFMutableDictionaryRef propertyDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
        CoreFoundation.INSTANCE.CFDictionarySetValue(propertyDict, locationIDKey, locationId);
        CoreFoundation.CFMutableDictionaryRef matchingDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
        CoreFoundation.INSTANCE.CFDictionarySetValue(matchingDict, ioPropertyMatchKey, propertyDict);
        IntByReference serviceIterator = new IntByReference();
        IOKitUtil.getMatchingServices(matchingDict, serviceIterator);
        CfUtil.release(propertyDict);
        boolean found = false;
        int matchingService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
        while (matchingService != 0 && !found) {
            byte[] pid;
            IntByReference parent = new IntByReference();
            IOKit.INSTANCE.IORegistryEntryGetParentEntry(matchingService, "IOService", parent);
            byte[] vid = IOKitUtil.getIORegistryByteArrayProperty(parent.getValue(), "vendor-id");
            if (vid != null && vid.length >= 2) {
                vendorIdMap.put(id, String.format("%02x%02x", vid[1], vid[0]));
                found = true;
            }
            if ((pid = IOKitUtil.getIORegistryByteArrayProperty(parent.getValue(), "device-id")) != null && pid.length >= 2) {
                productIdMap.put(id, String.format("%02x%02x", pid[1], pid[0]));
                found = true;
            }
            matchingService = IOKit.INSTANCE.IOIteratorNext(matchingService);
        }
    }

    private static MacUsbDevice getDeviceAndChildren(Long registryEntryId, String vid, String pid, Map<Long, String> nameMap, Map<Long, String> vendorMap, Map<Long, String> vendorIdMap, Map<Long, String> productIdMap, Map<Long, String> serialMap, Map<Long, List<Long>> hubMap) {
        String vendorId = vendorIdMap.getOrDefault(registryEntryId, vid);
        String productId = productIdMap.getOrDefault(registryEntryId, pid);
        List childIds = hubMap.getOrDefault(registryEntryId, new ArrayList());
        ArrayList<MacUsbDevice> usbDevices = new ArrayList<MacUsbDevice>();
        for (Long id : childIds) {
            usbDevices.add(MacUsbDevice.getDeviceAndChildren(id, vendorId, productId, nameMap, vendorMap, vendorIdMap, productIdMap, serialMap, hubMap));
        }
        Collections.sort(usbDevices);
        return new MacUsbDevice(nameMap.getOrDefault(registryEntryId, vendorId + ":" + productId), vendorMap.getOrDefault(registryEntryId, ""), vendorId, productId, serialMap.getOrDefault(registryEntryId, ""), "0x" + Long.toHexString(registryEntryId), usbDevices.toArray(new UsbDevice[0]));
    }
}

