/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oshi.hardware.common.AbstractSensors;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class LinuxSensors
extends AbstractSensors {
    private static final long serialVersionUID = 1L;
    private static final String TEMP = "temp";
    private static final String FAN = "fan";
    private static final String VOLTAGE = "in";
    private static final String[] SENSORS = new String[]{"temp", "fan", "in"};
    private static final String HWMON = "/sys/class/hwmon/hwmon";
    private static final String THERMAL_ZONE = "/sys/class/thermal/thermal_zone";
    private Map<String, String> sensorsMap = new HashMap<String, String>();

    public LinuxSensors() {
        this.iterateHwmon();
        if (!this.sensorsMap.containsKey(TEMP)) {
            this.iterateThermalZone();
        }
    }

    private void iterateHwmon() {
        String[] stringArray = SENSORS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String sensor;
            String sensorPrefix = sensor = stringArray[i];
            this.getSensorFilesFromPath(HWMON, sensor, f -> {
                try {
                    return f.getName().startsWith(sensorPrefix) && f.getName().endsWith("_input") && FileUtil.getIntFromFile(f.getCanonicalPath()) > 0;
                }
                catch (IOException e) {
                    return false;
                }
            });
        }
    }

    private void iterateThermalZone() {
        this.getSensorFilesFromPath(THERMAL_ZONE, TEMP, f -> f.getName().equals(TEMP));
    }

    private void getSensorFilesFromPath(String sensorPath, String sensor, FileFilter sensorFileFilter) {
        int i = 0;
        while (Paths.get(sensorPath + i, new String[0]).toFile().isDirectory()) {
            String path = sensorPath + i;
            File dir = new File(path);
            File[] matchingFiles = dir.listFiles(sensorFileFilter);
            if (matchingFiles != null && matchingFiles.length > 0) {
                this.sensorsMap.put(sensor, String.format("%s/%s", path, sensor));
            }
            ++i;
        }
    }

    @Override
    public double getCpuTemperature() {
        String tempStr;
        if (!this.sensorsMap.containsKey(TEMP)) {
            return 0.0;
        }
        long millidegrees = 0L;
        String hwmon = this.sensorsMap.get(TEMP);
        if (hwmon.contains("hwmon")) {
            millidegrees = FileUtil.getLongFromFile(String.format("%s1_input", hwmon));
            if (millidegrees > 0L) {
                return (double)millidegrees / 1000.0;
            }
            long sum = 0L;
            int count = 0;
            for (int i = 2; i <= 6; ++i) {
                millidegrees = FileUtil.getLongFromFile(String.format("%s%d_input", hwmon, i));
                if (millidegrees <= 0L) continue;
                sum += millidegrees;
                ++count;
            }
            if (count > 0) {
                return (double)sum / ((double)count * 1000.0);
            }
        } else if (hwmon.contains("thermal_zone") && (millidegrees = FileUtil.getLongFromFile(hwmon)) > 0L) {
            return (double)millidegrees / 1000.0;
        }
        if ((tempStr = ExecutingCommand.getFirstAnswer("vcgencmd measure_temp")).startsWith("temp=") && tempStr.endsWith("'C")) {
            return ParseUtil.parseDoubleOrDefault(tempStr.replaceAll("\\^[0-9]+(\\.[0-9]{1,4})?$", ""), 0.0);
        }
        return 0.0;
    }

    @Override
    public int[] getFanSpeeds() {
        if (this.sensorsMap.containsKey(FAN)) {
            String fanPath;
            String hwmon = this.sensorsMap.get(FAN);
            ArrayList<Integer> speeds = new ArrayList<Integer>();
            int fan = 1;
            while (new File(fanPath = String.format("%s%d_input", hwmon, fan)).exists()) {
                speeds.add(FileUtil.getIntFromFile(fanPath));
                ++fan;
            }
            int[] fanSpeeds = new int[speeds.size()];
            for (int i = 0; i < speeds.size(); ++i) {
                fanSpeeds[i] = (Integer)speeds.get(i);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    @Override
    public double getCpuVoltage() {
        if (this.sensorsMap.containsKey(VOLTAGE)) {
            String hwmon = this.sensorsMap.get(VOLTAGE);
            return (double)FileUtil.getIntFromFile(String.format("%s1_input", hwmon)) / 1000.0;
        }
        String tempVolts = ExecutingCommand.getFirstAnswer("vcgencmd measure_volts core");
        if (tempVolts.startsWith("volt=") && tempVolts.endsWith("V")) {
            return ParseUtil.parseDoubleOrDefault(tempVolts.replaceAll("\\^[0-9]+(\\.[0-9]{1,4})?$", ""), 0.0);
        }
        return 0.0;
    }
}

