/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import com.sun.jna.win32.W32APITypeMapper;
import java.util.Map;
import oshi.jna.platform.windows.WinNT;

public interface Wtsapi32
extends com.sun.jna.platform.win32.Wtsapi32 {
    public static final Wtsapi32 INSTANCE = (Wtsapi32)Native.load((String)"Wtsapi32", Wtsapi32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    public static final int DOMAIN_LENGTH = 17;
    public static final int USERNAME_LENGTH = 20;
    public static final int WINSTATIONNAME_LENGTH = 32;

    public boolean WTSEnumerateSessions(WinNT.HANDLE var1, int var2, int var3, PointerByReference var4, IntByReference var5);

    public boolean WTSQuerySessionInformation(WinNT.HANDLE var1, int var2, int var3, PointerByReference var4, IntByReference var5);

    public void WTSFreeMemory(Pointer var1);

    @Structure.FieldOrder(value={"State", "SessionId", "IncomingBytes", "OutgoingBytes", "IncomingFrames", "OutgoingFrames", "IncomingCompressedBytes", "OutgoingCompressedBytes", "WinStationName", "Domain", "UserName", "ConnectTime", "DisconnectTime", "LastInputTime", "LogonTime", "CurrentTime"})
    public static class WTSINFO
    extends Structure {
        private static final int CHAR_WIDTH = Boolean.getBoolean("w32.ascii") ? 1 : 2;
        public int State;
        public int SessionId;
        public int IncomingBytes;
        public int OutgoingBytes;
        public int IncomingFrames;
        public int OutgoingFrames;
        public int IncomingCompressedBytes;
        public int OutgoingCompressedBytes;
        public final byte[] WinStationName = new byte[32 * CHAR_WIDTH];
        public final byte[] Domain = new byte[17 * CHAR_WIDTH];
        public final byte[] UserName = new byte[21 * CHAR_WIDTH];
        public WinNT.LARGE_INTEGER ConnectTime;
        public WinNT.LARGE_INTEGER DisconnectTime;
        public WinNT.LARGE_INTEGER LastInputTime;
        public WinNT.LARGE_INTEGER LogonTime;
        public WinNT.LARGE_INTEGER CurrentTime;

        public WTSINFO() {
        }

        public WTSINFO(Pointer p) {
            super(p);
            this.read();
        }

        public String getWinStationName() {
            return this.getStringAtOffset(this.fieldOffset("WinStationName"));
        }

        public String getDomain() {
            return this.getStringAtOffset(this.fieldOffset("Domain"));
        }

        public String getUserName() {
            return this.getStringAtOffset(this.fieldOffset("UserName"));
        }

        private String getStringAtOffset(int offset) {
            return CHAR_WIDTH == 1 ? this.getPointer().getString((long)offset) : this.getPointer().getWideString((long)offset);
        }
    }

    @Structure.FieldOrder(value={"AddressFamily", "Address"})
    public static class WTS_CLIENT_ADDRESS
    extends Structure {
        public int AddressFamily;
        public byte[] Address = new byte[20];

        public WTS_CLIENT_ADDRESS() {
        }

        public WTS_CLIENT_ADDRESS(Pointer p) {
            super(p);
            this.read();
        }
    }

    @Structure.FieldOrder(value={"SessionId", "pWinStationName", "State"})
    public static class WTS_SESSION_INFO
    extends Structure {
        public int SessionId;
        public String pWinStationName;
        public int State;

        public WTS_SESSION_INFO() {
            super(W32APITypeMapper.DEFAULT);
        }

        public WTS_SESSION_INFO(Pointer p) {
            super(p, 0, W32APITypeMapper.DEFAULT);
            this.read();
        }
    }

    public static interface WTS_INFO_CLASS {
        public static final int WTSInitialProgram = 0;
        public static final int WTSApplicationName = 1;
        public static final int WTSWorkingDirectory = 2;
        public static final int WTSOEMId = 3;
        public static final int WTSSessionId = 4;
        public static final int WTSUserName = 5;
        public static final int WTSWinStationName = 6;
        public static final int WTSDomainName = 7;
        public static final int WTSConnectState = 8;
        public static final int WTSClientBuildNumber = 9;
        public static final int WTSClientName = 10;
        public static final int WTSClientDirectory = 11;
        public static final int WTSClientProductId = 12;
        public static final int WTSClientHardwareId = 13;
        public static final int WTSClientAddress = 14;
        public static final int WTSClientDisplay = 15;
        public static final int WTSClientProtocolType = 16;
        public static final int WTSIdleTime = 17;
        public static final int WTSLogonTime = 18;
        public static final int WTSIncomingBytes = 19;
        public static final int WTSOutgoingBytes = 20;
        public static final int WTSIncomingFrames = 21;
        public static final int WTSOutgoingFrames = 22;
        public static final int WTSClientInfo = 23;
        public static final int WTSSessionInfo = 24;
        public static final int WTSSessionInfoEx = 25;
        public static final int WTSConfigInfo = 26;
        public static final int WTSValidationInfo = 27;
        public static final int WTSSessionAddressV4 = 28;
        public static final int WTSIsRemoteSession = 29;
    }

    public static interface WTS_CONNECTSTATE_CLASS {
        public static final int WTSActive = 0;
        public static final int WTSConnected = 1;
        public static final int WTSConnectQuery = 2;
        public static final int WTSShadow = 3;
        public static final int WTSDisconnected = 4;
        public static final int WTSIdle = 5;
        public static final int WTSListen = 6;
        public static final int WTSReset = 7;
        public static final int WTSDown = 8;
        public static final int WTSInit = 9;
    }
}

