/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.perfmon.ProcessInformation;
import oshi.driver.windows.registry.HkeyPerformanceDataUtil;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class ProcessPerformanceData {
    private static final String PROCESS = "Process";

    private ProcessPerformanceData() {
    }

    public static Map<Integer, OSProcess> buildProcessMapFromRegistry(OperatingSystem os, Collection<Integer> pids) {
        Triplet<List<Map<ProcessInformation.ProcessPerformanceProperty, Object>>, Long, Long> processData = HkeyPerformanceDataUtil.readPerfDataFromRegistry(PROCESS, ProcessInformation.ProcessPerformanceProperty.class);
        if (processData == null) {
            return null;
        }
        List<Map<ProcessInformation.ProcessPerformanceProperty, Object>> processInstanceMaps = processData.getA();
        long perfTime100nSec = processData.getB();
        long now = processData.getC();
        HashMap<Integer, OSProcess> processMap = new HashMap<Integer, OSProcess>();
        for (Map<ProcessInformation.ProcessPerformanceProperty, Object> processInstanceMap : processInstanceMaps) {
            int pid = (Integer)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PROCESSID);
            String name = (String)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.NAME);
            if (pids != null && !pids.contains(pid) || "_Total".equals(name)) continue;
            OSProcess proc = new OSProcess(os);
            proc.setProcessID(pid);
            proc.setName(name);
            long upTime = (perfTime100nSec - (Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.CREATIONDATE)) / 10000L;
            proc.setUpTime(upTime < 1L ? 1L : upTime);
            proc.setStartTime(now - upTime);
            proc.setBytesRead((Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.READTRANSFERCOUNT));
            proc.setBytesWritten((Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.WRITETRANSFERCOUNT));
            proc.setResidentSetSize((Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PRIVATEPAGECOUNT));
            proc.setParentProcessID((Integer)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PARENTPROCESSID));
            proc.setPriority((Integer)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PRIORITY));
            processMap.put(pid, proc);
        }
        return processMap;
    }
}

