/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux.proc;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class ProcessStat {
    private static final Pattern DIGITS = Pattern.compile("\\d+");

    private ProcessStat() {
    }

    public static Triplet<String, Character, Map<PidStat, Long>> getPidStats(int pid) {
        String stat = FileUtil.getStringFromFile(String.format(ProcPath.PID_STAT, pid));
        if (stat.isEmpty()) {
            return null;
        }
        int nameStart = stat.indexOf(40) + 1;
        int nameEnd = stat.indexOf(41);
        String name = stat.substring(nameStart, nameEnd);
        Character state = Character.valueOf(stat.charAt(nameEnd + 2));
        String[] split = ParseUtil.whitespaces.split(stat.substring(nameEnd + 4).trim());
        EnumMap<PidStat, Long> statMap = new EnumMap<PidStat, Long>(PidStat.class);
        PidStat[] enumArray = (PidStat[])PidStat.class.getEnumConstants();
        for (int i = 3; i < enumArray.length && i - 3 < split.length; ++i) {
            statMap.put(enumArray[i], ParseUtil.parseLongOrDefault(split[i - 3], 0L));
        }
        return new Triplet<String, Character, Map<PidStat, Long>>(name, state, statMap);
    }

    public static File[] getPidFiles() {
        File procdir = new File(ProcPath.PROC);
        File[] pids = procdir.listFiles(f -> DIGITS.matcher(f.getName()).matches());
        return pids != null ? pids : new File[]{};
    }

    public static enum PidStat {
        PID,
        COMM,
        STATE,
        PPID,
        PGRP,
        SESSION,
        TTY_NR,
        PTGID,
        FLAGS,
        MINFLT,
        CMINFLT,
        MAJFLT,
        CMAJFLT,
        UTIME,
        STIME,
        CUTIME,
        CSTIME,
        PRIORITY,
        NICE,
        NUM_THREADS,
        ITREALVALUE,
        STARTTIME,
        VSIZE,
        RSS,
        RSSLIM,
        STARTCODE,
        ENDCODE,
        STARTSTACK,
        KSTKESP,
        KSTKEIP,
        SIGNAL,
        BLOCKED,
        SIGIGNORE,
        SIGCATCH,
        WCHAN,
        NSWAP,
        CNSWAP,
        EXIT_SIGNAL,
        PROCESSOR,
        RT_PRIORITY,
        POLICY,
        DELAYACCT_BLKIO_TICKS,
        GUEST_TIME,
        CGUEST_TIME,
        START_DATA,
        END_DATA,
        START_BRK,
        ARG_START,
        ARG_END,
        ENV_START,
        ENV_END,
        EXIT_CODE;

    }
}

