/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.jna.platform.linux.Udev;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

public class LinuxDisks
implements Disks {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxDisks.class);
    private static final int SECTORSIZE = 512;
    private final Map<String, String> mountsMap = new HashMap<String, String>();
    private static final Map<Integer, String> hashCodeToPathMap = new HashMap<Integer, String>();
    private static final int[] UDEV_STAT_ORDERS = new int[UdevStat.values().length];
    private static final int UDEV_STAT_LENGTH;

    @Override
    public HWDiskStore[] getDisks() {
        Udev.UdevDevice device;
        HWDiskStore store = null;
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        this.updateMountsMap();
        hashCodeToPathMap.clear();
        Udev.UdevHandle handle = Udev.INSTANCE.udev_new();
        Udev.UdevEnumerate enumerate = Udev.INSTANCE.udev_enumerate_new(handle);
        Udev.INSTANCE.udev_enumerate_add_match_subsystem(enumerate, "block");
        Udev.INSTANCE.udev_enumerate_scan_devices(enumerate);
        Udev.UdevListEntry entry = Udev.INSTANCE.udev_enumerate_get_list_entry(enumerate);
        while ((device = Udev.INSTANCE.udev_device_new_from_syspath(handle, Udev.INSTANCE.udev_list_entry_get_name(entry))) != null) {
            String devnode = Udev.INSTANCE.udev_device_get_devnode(device);
            if (devnode != null) {
                if (!devnode.startsWith("/dev/loop") && !devnode.startsWith("/dev/ram")) {
                    if ("disk".equals(Udev.INSTANCE.udev_device_get_devtype(device))) {
                        store = new HWDiskStore();
                        store.setName(devnode);
                        store.setModel(Udev.INSTANCE.udev_device_get_property_value(device, "ID_MODEL") == null ? "Unknown" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_MODEL"));
                        store.setSerial(Udev.INSTANCE.udev_device_get_property_value(device, "ID_SERIAL_SHORT") == null ? "Unknown" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_SERIAL_SHORT"));
                        store.setSize(ParseUtil.parseLongOrDefault(Udev.INSTANCE.udev_device_get_sysattr_value(device, "size"), 0L) * 512L);
                        store.setPartitions(new HWPartition[0]);
                        LinuxDisks.computeDiskStats(store, device);
                        hashCodeToPathMap.put(store.hashCode(), Udev.INSTANCE.udev_list_entry_get_name(entry));
                        result.add(store);
                    } else if ("partition".equals(Udev.INSTANCE.udev_device_get_devtype(device)) && store != null) {
                        HWPartition[] partArray = new HWPartition[store.getPartitions().length + 1];
                        System.arraycopy(store.getPartitions(), 0, partArray, 0, store.getPartitions().length);
                        String name = Udev.INSTANCE.udev_device_get_devnode(device);
                        partArray[partArray.length - 1] = new HWPartition(name, Udev.INSTANCE.udev_device_get_sysname(device), Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_TYPE") == null ? "partition" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_TYPE"), Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_UUID") == null ? "" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_FS_UUID"), ParseUtil.parseLongOrDefault(Udev.INSTANCE.udev_device_get_sysattr_value(device, "size"), 0L) * 512L, ParseUtil.parseIntOrDefault(Udev.INSTANCE.udev_device_get_property_value(device, "MAJOR"), 0), ParseUtil.parseIntOrDefault(Udev.INSTANCE.udev_device_get_property_value(device, "MINOR"), 0), this.mountsMap.getOrDefault(name, ""));
                        store.setPartitions(partArray);
                    }
                }
            } else {
                LOG.warn("Failed to retrieve devnode for device {}", (Object)Pointer.nativeValue((Pointer)device.getPointer()));
            }
            Udev.INSTANCE.udev_device_unref(device);
            entry = Udev.INSTANCE.udev_list_entry_get_next(entry);
        }
        Udev.INSTANCE.udev_enumerate_unref(enumerate);
        Udev.INSTANCE.udev_unref(handle);
        return result.toArray(new HWDiskStore[0]);
    }

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String path = hashCodeToPathMap.get(diskStore.hashCode());
        Udev.UdevHandle handle = Udev.INSTANCE.udev_new();
        Udev.UdevDevice device = Udev.INSTANCE.udev_device_new_from_syspath(handle, path);
        boolean update = false;
        if (device != null) {
            LinuxDisks.computeDiskStats(diskStore, device);
            update = true;
            Udev.INSTANCE.udev_device_unref(device);
        }
        Udev.INSTANCE.udev_unref(handle);
        return update;
    }

    private void updateMountsMap() {
        this.mountsMap.clear();
        List<String> mounts = FileUtil.readFile(ProcPath.MOUNTS);
        for (String mount : mounts) {
            String[] split = ParseUtil.whitespaces.split(mount);
            if (split.length < 2 || !split[0].startsWith("/dev/")) continue;
            this.mountsMap.put(split[0], split[1]);
        }
    }

    private static void computeDiskStats(HWDiskStore store, Udev.UdevDevice disk) {
        String devstat = Udev.INSTANCE.udev_device_get_sysattr_value(disk, "stat");
        long[] devstatArray = ParseUtil.parseStringToLongArray(devstat, UDEV_STAT_ORDERS, UDEV_STAT_LENGTH, ' ');
        store.setTimeStamp(System.currentTimeMillis());
        store.setReads(devstatArray[UdevStat.READS.ordinal()]);
        store.setReadBytes(devstatArray[UdevStat.READ_BYTES.ordinal()] * 512L);
        store.setWrites(devstatArray[UdevStat.WRITES.ordinal()]);
        store.setWriteBytes(devstatArray[UdevStat.WRITE_BYTES.ordinal()] * 512L);
        store.setCurrentQueueLength(devstatArray[UdevStat.QUEUE_LENGTH.ordinal()]);
        store.setTransferTime(devstatArray[UdevStat.ACTIVE_MS.ordinal()]);
    }

    static {
        for (UdevStat stat : UdevStat.values()) {
            LinuxDisks.UDEV_STAT_ORDERS[stat.ordinal()] = stat.getOrder();
        }
        String stat = FileUtil.getStringFromFile(ProcPath.DISKSTATS);
        int statLength = 11;
        if (!stat.isEmpty()) {
            statLength = ParseUtil.countStringToLongArray(stat, ' ');
        }
        UDEV_STAT_LENGTH = statLength;
    }

    static enum UdevStat {
        READS(0),
        READ_BYTES(2),
        WRITES(4),
        WRITE_BYTES(6),
        QUEUE_LENGTH(8),
        ACTIVE_MS(9);

        private int order;

        public int getOrder() {
            return this.order;
        }

        private UdevStat(int order) {
            this.order = order;
        }
    }
}

