/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.platform.linux.LinuxNetworks;
import oshi.hardware.platform.mac.MacNetworks;
import oshi.hardware.platform.unix.freebsd.FreeBsdNetworks;
import oshi.hardware.platform.unix.solaris.SolarisNetworks;
import oshi.hardware.platform.windows.WindowsNetworks;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;

public class NetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkIF.class);
    private NetworkInterface networkInterface;
    private int mtu;
    private String mac;
    private String[] ipv4;
    private Short[] subnetMasks;
    private String[] ipv6;
    private Short[] prefixLengths;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;

    public NetworkInterface queryNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterface = networkInterface;
        try {
            this.mtu = networkInterface.getMTU();
            byte[] hwmac = networkInterface.getHardwareAddress();
            if (hwmac != null) {
                ArrayList<String> octets = new ArrayList<String>(6);
                for (byte b : hwmac) {
                    octets.add(String.format("%02x", b));
                }
                this.mac = String.join((CharSequence)":", octets);
            } else {
                this.mac = "Unknown";
            }
            ArrayList<String> ipv4list = new ArrayList<String>();
            ArrayList<Short> subnetMaskList = new ArrayList<Short>();
            ArrayList<String> ipv6list = new ArrayList<String>();
            ArrayList<Short> prefixLengthList = new ArrayList<Short>();
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress address = interfaceAddress.getAddress();
                if (address.getHostAddress().length() <= 0) continue;
                if (address.getHostAddress().contains(":")) {
                    ipv6list.add(address.getHostAddress().split("%")[0]);
                    prefixLengthList.add(interfaceAddress.getNetworkPrefixLength());
                    continue;
                }
                ipv4list.add(address.getHostAddress());
                subnetMaskList.add(interfaceAddress.getNetworkPrefixLength());
            }
            this.ipv4 = ipv4list.toArray(new String[0]);
            this.subnetMasks = subnetMaskList.toArray(new Short[0]);
            this.ipv6 = ipv6list.toArray(new String[0]);
            this.prefixLengths = prefixLengthList.toArray(new Short[0]);
        }
        catch (SocketException e) {
            LOG.error("Socket exception: {}", (Object)e.getMessage());
        }
    }

    public String getName() {
        return this.networkInterface.getName();
    }

    public String getDisplayName() {
        return this.networkInterface.getDisplayName();
    }

    public int getMTU() {
        return this.mtu;
    }

    public String getMacaddr() {
        return this.mac;
    }

    public String[] getIPv4addr() {
        return Arrays.copyOf(this.ipv4, this.ipv4.length);
    }

    public Short[] getSubnetMasks() {
        return Arrays.copyOf(this.subnetMasks, this.subnetMasks.length);
    }

    public String[] getIPv6addr() {
        return Arrays.copyOf(this.ipv6, this.ipv6.length);
    }

    public Short[] getPrefixLengths() {
        return Arrays.copyOf(this.prefixLengths, this.prefixLengths.length);
    }

    public long getBytesRecv() {
        return this.bytesRecv;
    }

    public void setBytesRecv(long bytesRecv) {
        this.bytesRecv = ParseUtil.unsignedLongToSignedLong(bytesRecv);
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = ParseUtil.unsignedLongToSignedLong(bytesSent);
    }

    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    public void setPacketsRecv(long packetsRecv) {
        this.packetsRecv = ParseUtil.unsignedLongToSignedLong(packetsRecv);
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    public void setPacketsSent(long packetsSent) {
        this.packetsSent = ParseUtil.unsignedLongToSignedLong(packetsSent);
    }

    public long getInErrors() {
        return this.inErrors;
    }

    public void setInErrors(long inErrors) {
        this.inErrors = ParseUtil.unsignedLongToSignedLong(inErrors);
    }

    public long getOutErrors() {
        return this.outErrors;
    }

    public void setOutErrors(long outErrors) {
        this.outErrors = ParseUtil.unsignedLongToSignedLong(outErrors);
    }

    public long getInDrops() {
        return this.inDrops;
    }

    public void setInDrops(long inDrops) {
        this.inDrops = inDrops;
    }

    public long getCollisions() {
        return this.collisions;
    }

    public void setCollisions(long collisions) {
        this.collisions = collisions;
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSpeed(long speed) {
        this.speed = ParseUtil.unsignedLongToSignedLong(speed);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean updateAttributes() {
        switch (SystemInfo.getCurrentPlatformEnum()) {
            case WINDOWS: {
                return WindowsNetworks.updateNetworkStats(this);
            }
            case LINUX: {
                return LinuxNetworks.updateNetworkStats(this);
            }
            case MACOSX: {
                return MacNetworks.updateNetworkStats(this);
            }
            case SOLARIS: {
                return SolarisNetworks.updateNetworkStats(this);
            }
            case FREEBSD: {
                return FreeBsdNetworks.updateNetworkStats(this);
            }
        }
        LOG.error("Unsupported platform. No update performed.");
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getName()).append(" ").append("(").append(this.getDisplayName()).append(")").append("\n");
        sb.append("  MAC Address: ").append(this.getMacaddr()).append("\n");
        sb.append("  MTU: ").append(this.getMTU()).append(", ").append("Speed: ").append(this.getSpeed()).append("\n");
        sb.append("  IPv4: ").append(Arrays.toString(this.getIPv4addr())).append("\n");
        sb.append("  Netmask:  ").append(Arrays.toString((Object[])this.getSubnetMasks())).append("\n");
        sb.append("  IPv6: ").append(Arrays.toString(this.getIPv6addr())).append("\n");
        sb.append("  Prefix Lengths:  ").append(Arrays.toString((Object[])this.getPrefixLengths())).append("\n");
        sb.append("  Traffic: received ").append(this.getPacketsRecv()).append(" packets/").append(FormatUtil.formatBytes(this.getBytesRecv())).append(" (" + this.getInErrors() + " err, ").append(this.getInDrops() + " drop);");
        sb.append(" transmitted ").append(this.getPacketsSent()).append(" packets/").append(FormatUtil.formatBytes(this.getBytesSent())).append(" (" + this.getOutErrors() + " err, ").append(this.getCollisions() + " coll);");
        return sb.toString();
    }
}

