/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.perfmon;

import java.util.List;
import java.util.Map;
import oshi.util.platform.windows.PerfCounterWildcardQuery;

public final class ThermalZoneInformation {
    private static final String THERMAL_ZONE_INFORMATION = "Thermal Zone Information";
    private static final String THERMAL_ZONE_INFORMATION_WHERE_NAME_LIKE_CPU = "Win32_PerfRawData_Counters_ThermalZoneInformation WHERE Name LIKE \"%cpu%\"";

    private ThermalZoneInformation() {
    }

    public static Map<ThermalZoneProperty, List<Long>> queryThermalZoneTemps() {
        PerfCounterWildcardQuery<ThermalZoneProperty> thermalZonePerfCounters = new PerfCounterWildcardQuery<ThermalZoneProperty>(ThermalZoneProperty.class, THERMAL_ZONE_INFORMATION, THERMAL_ZONE_INFORMATION_WHERE_NAME_LIKE_CPU);
        return thermalZonePerfCounters.queryValuesWildcard();
    }

    public static enum ThermalZoneProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("*cpu*"),
        TEMPERATURE("Temperature");

        private final String counter;

        private ThermalZoneProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

