/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oshi.software.common.AbstractFileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfCounterWildcardQuery;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsFileSystem
extends AbstractFileSystem {
    private static final int BUFSIZE = 255;
    private static final int SEM_FAILCRITICALERRORS = 1;
    private static final int FILE_CASE_SENSITIVE_SEARCH = 1;
    private static final int FILE_CASE_PRESERVED_NAMES = 2;
    private static final int FILE_FILE_COMPRESSION = 16;
    private static final int FILE_DAX_VOLUME = 0x20000000;
    private static final int FILE_NAMED_STREAMS = 262144;
    private static final int FILE_PERSISTENT_ACLS = 8;
    private static final int FILE_READ_ONLY_VOLUME = 524288;
    private static final int FILE_SEQUENTIAL_WRITE_ONCE = 0x100000;
    private static final int FILE_SUPPORTS_ENCRYPTION = 131072;
    private static final int FILE_SUPPORTS_OBJECT_IDS = 65536;
    private static final int FILE_SUPPORTS_REPARSE_POINTS = 128;
    private static final int FILE_SUPPORTS_SPARSE_FILES = 64;
    private static final int FILE_SUPPORTS_TRANSACTIONS = 0x200000;
    private static final int FILE_SUPPORTS_USN_JOURNAL = 0x2000000;
    private static final int FILE_UNICODE_ON_DISK = 4;
    private static final int FILE_VOLUME_IS_COMPRESSED = 32768;
    private static final int FILE_VOLUME_QUOTAS = 32;
    private static final Map<Integer, String> OPTIONS_MAP = new HashMap<Integer, String>();
    private final PerfCounterWildcardQuery<HandleCountProperty> handlePerfCounters = new PerfCounterWildcardQuery<HandleCountProperty>(HandleCountProperty.class, "Process", "Win32_Process");
    private static final long MAX_WINDOWS_HANDLES;

    public WindowsFileSystem() {
        Kernel32.INSTANCE.SetErrorMode(1);
    }

    @Override
    public OSFileStore[] getFileStores(boolean localOnly) {
        ArrayList<OSFileStore> result = WindowsFileSystem.getLocalVolumes(null);
        HashMap<String, OSFileStore> volumeMap = new HashMap<String, OSFileStore>();
        for (OSFileStore volume : result) {
            volumeMap.put(volume.getMount(), volume);
        }
        for (OSFileStore wmiVolume : WindowsFileSystem.getWmiVolumes(null, localOnly)) {
            if (volumeMap.containsKey(wmiVolume.getMount())) {
                ((OSFileStore)volumeMap.get(wmiVolume.getMount())).setName(wmiVolume.getName());
                continue;
            }
            if (localOnly) continue;
            result.add(wmiVolume);
        }
        return result.toArray(new OSFileStore[0]);
    }

    private static ArrayList<OSFileStore> getLocalVolumes(String nameToMatch) {
        boolean retVal;
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        char[] aVolume = new char[255];
        WinNT.HANDLE hVol = Kernel32.INSTANCE.FindFirstVolume(aVolume, 255);
        if (hVol == WinBase.INVALID_HANDLE_VALUE) {
            return fs;
        }
        do {
            char[] fstype = new char[16];
            char[] name = new char[255];
            char[] mount = new char[255];
            IntByReference pFlags = new IntByReference();
            WinNT.LARGE_INTEGER userFreeBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER totalBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER systemFreeBytes = new WinNT.LARGE_INTEGER(0L);
            String volume = new String(aVolume).trim();
            Kernel32.INSTANCE.GetVolumeInformation(volume, name, 255, null, null, pFlags, fstype, 16);
            int flags = pFlags.getValue();
            Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(volume, mount, 255, null);
            String strMount = new String(mount).trim();
            if (strMount.isEmpty()) continue;
            String strName = new String(name).trim();
            String strFsType = new String(fstype).trim();
            StringBuilder options = new StringBuilder((0x80000 & flags) == 0 ? "rw" : "ro");
            String moreOptions = OPTIONS_MAP.entrySet().stream().filter(e -> ((Integer)e.getKey() & flags) > 0).map(Map.Entry::getValue).collect(Collectors.joining(","));
            if (!moreOptions.isEmpty()) {
                options.append(',').append(moreOptions);
            }
            String osName = String.format("%s (%s)", strName, strMount);
            if (nameToMatch != null && !nameToMatch.equals(osName)) continue;
            Kernel32.INSTANCE.GetDiskFreeSpaceEx(volume, userFreeBytes, totalBytes, systemFreeBytes);
            String uuid = ParseUtil.parseUuidOrDefault(volume, "");
            OSFileStore osStore = new OSFileStore();
            osStore.setName(osName);
            osStore.setVolume(volume);
            osStore.setMount(strMount);
            osStore.setDescription(WindowsFileSystem.getDriveType(strMount));
            osStore.setType(strFsType);
            osStore.setOptions(options.toString());
            osStore.setUUID(uuid);
            osStore.setFreeSpace(systemFreeBytes.getValue());
            osStore.setUsableSpace(userFreeBytes.getValue());
            osStore.setTotalSpace(totalBytes.getValue());
            System.out.println(osStore.toString());
            fs.add(osStore);
        } while (retVal = Kernel32.INSTANCE.FindNextVolume(hVol, aVolume, 255));
        Kernel32.INSTANCE.FindVolumeClose(hVol);
        return fs;
    }

    private static List<OSFileStore> getWmiVolumes(String nameToMatch, boolean localOnly) {
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        StringBuilder wmiClassName = new StringBuilder("Win32_LogicalDisk");
        boolean where = false;
        if (localOnly) {
            wmiClassName.append(" WHERE DriveType != 4");
            where = true;
        }
        if (nameToMatch != null) {
            wmiClassName.append(where ? " WHERE" : " AND").append(" Name=\"").append(nameToMatch).append('\"');
        }
        WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
        WbemcliUtil.WmiQuery logicalDiskQuery = new WbemcliUtil.WmiQuery(wmiClassName.toString(), LogicalDiskProperty.class);
        WbemcliUtil.WmiResult drives = wmiQueryHandler.queryWMI(logicalDiskQuery);
        for (int i = 0; i < drives.getResultCount(); ++i) {
            String volume;
            long free = WmiUtil.getUint64(drives, LogicalDiskProperty.FREESPACE, i);
            long total = WmiUtil.getUint64(drives, LogicalDiskProperty.SIZE, i);
            String description = WmiUtil.getString(drives, LogicalDiskProperty.DESCRIPTION, i);
            String name = WmiUtil.getString(drives, LogicalDiskProperty.NAME, i);
            int type = WmiUtil.getUint32(drives, LogicalDiskProperty.DRIVETYPE, i);
            if (type != 4) {
                char[] chrVolume = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(name + "\\", chrVolume, 255);
                volume = new String(chrVolume).trim();
            } else {
                volume = WmiUtil.getString(drives, LogicalDiskProperty.PROVIDERNAME, i);
                String[] split = volume.split("\\\\");
                if (split.length > 1 && split[split.length - 1].length() > 0) {
                    description = split[split.length - 1];
                }
            }
            OSFileStore osStore = new OSFileStore();
            osStore.setName(String.format("%s (%s)", description, name));
            osStore.setVolume(volume);
            osStore.setMount(name + "\\");
            osStore.setDescription(WindowsFileSystem.getDriveType(name));
            osStore.setType(WmiUtil.getString(drives, LogicalDiskProperty.FILESYSTEM, i));
            osStore.setUUID("");
            osStore.setFreeSpace(free);
            osStore.setUsableSpace(free);
            osStore.setTotalSpace(total);
            fs.add(osStore);
        }
        return fs;
    }

    private static String getDriveType(String drive) {
        switch (Kernel32.INSTANCE.GetDriveType(drive)) {
            case 2: {
                return "Removable drive";
            }
            case 3: {
                return "Fixed drive";
            }
            case 4: {
                return "Network drive";
            }
            case 5: {
                return "CD-ROM";
            }
            case 6: {
                return "RAM drive";
            }
        }
        return "Unknown drive type";
    }

    @Override
    public long getOpenFileDescriptors() {
        Map<HandleCountProperty, List<Long>> valueListMap = this.handlePerfCounters.queryValuesWildcard();
        List<Long> valueList = valueListMap.get(HandleCountProperty.HANDLECOUNT);
        long descriptors = 0L;
        if (valueList != null) {
            for (int i = 0; i < valueList.size(); ++i) {
                descriptors += valueList.get(i).longValue();
            }
        }
        return descriptors;
    }

    @Override
    public long getMaxFileDescriptors() {
        return MAX_WINDOWS_HANDLES;
    }

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        List<OSFileStore> volumes = WindowsFileSystem.getLocalVolumes(osFileStore.getName());
        if (volumes.isEmpty()) {
            volumes = WindowsFileSystem.getWmiVolumes(osFileStore.getName(), false);
        }
        for (OSFileStore fileStore : volumes) {
            if (!osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }

    static {
        OPTIONS_MAP.put(2, "casepn");
        OPTIONS_MAP.put(1, "casess");
        OPTIONS_MAP.put(16, "fcomp");
        OPTIONS_MAP.put(0x20000000, "dax");
        OPTIONS_MAP.put(262144, "streams");
        OPTIONS_MAP.put(8, "acls");
        OPTIONS_MAP.put(0x100000, "wronce");
        OPTIONS_MAP.put(131072, "efs");
        OPTIONS_MAP.put(65536, "oids");
        OPTIONS_MAP.put(128, "reparse");
        OPTIONS_MAP.put(64, "sparse");
        OPTIONS_MAP.put(0x200000, "trans");
        OPTIONS_MAP.put(0x2000000, "journaled");
        OPTIONS_MAP.put(4, "unicode");
        OPTIONS_MAP.put(32768, "vcomp");
        OPTIONS_MAP.put(32, "quota");
        MAX_WINDOWS_HANDLES = System.getenv("ProgramFiles(x86)") == null ? 0xFF8000L : 0xFF0000L;
    }

    static enum HandleCountProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("_Total"),
        HANDLECOUNT("Handle Count");

        private final String counter;

        private HandleCountProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    static enum LogicalDiskProperty {
        DESCRIPTION,
        DRIVETYPE,
        FILESYSTEM,
        FREESPACE,
        NAME,
        PROVIDERNAME,
        SIZE;

    }
}

