/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdPowerSource
extends AbstractPowerSource {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdPowerSource.class);

    public FreeBsdPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized FreeBsdPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        PowerSource[] ps = new FreeBsdPowerSource[]{FreeBsdPowerSource.getPowerSource("BAT0")};
        return ps;
    }

    private static FreeBsdPowerSource getPowerSource(String name) {
        int state = BsdSysctlUtil.sysctl("hw.acpi.battery.state", 0);
        int time = BsdSysctlUtil.sysctl("hw.acpi.battery.time", -1);
        int life = BsdSysctlUtil.sysctl("hw.acpi.battery.life", 100);
        double timeRemaining = -2.0;
        if (state < 2) {
            timeRemaining = time < 0 ? -1.0 : 60.0 * (double)time;
        }
        return new FreeBsdPowerSource(name, (double)life / 100.0, timeRemaining);
    }

    @Override
    public void updateAttributes() {
        FreeBsdPowerSource ps = FreeBsdPowerSource.getPowerSource(this.name);
        this.remainingCapacity = ps.getRemainingCapacity();
        this.timeRemaining = ps.getTimeRemaining();
    }
}

