/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.regex.Pattern;
import oshi.hardware.CentralProcessor;
import oshi.util.FileUtil;
import oshi.util.GlobalConfig;
import oshi.util.ParseUtil;

public class ProcUtil {
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private static String proc = GlobalConfig.get("oshi.util.proc.path", "/proc");

    private ProcUtil() {
    }

    public static String getProcPath() {
        return proc;
    }

    public static double getSystemUptimeSeconds() {
        String uptime = FileUtil.getStringFromFile(proc + "/uptime");
        int spaceIndex = uptime.indexOf(32);
        try {
            if (spaceIndex < 0) {
                return 0.0;
            }
            return Double.parseDouble(uptime.substring(0, spaceIndex));
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    public static long[] readSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        List<String> procStat = FileUtil.readFile(proc + "/stat");
        if (procStat.isEmpty()) {
            return ticks;
        }
        String tickStr = procStat.get(0);
        String[] tickArr = ParseUtil.whitespaces.split(tickStr);
        if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
            return ticks;
        }
        for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
            ticks[i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
        }
        return ticks;
    }

    public static File[] getPidFiles() {
        File procdir = new File(proc);
        File[] pids = procdir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return DIGITS.matcher(file.getName()).matches();
            }
        });
        return pids != null ? pids : new File[]{};
    }

    static {
        if (proc.endsWith("/")) {
            proc = proc.substring(0, proc.length() - 1);
        }
        if (!proc.startsWith("/")) {
            proc = "/" + proc;
        }
        if (!new File(proc).exists()) {
            throw new GlobalConfig.PropertyException("oshi.util.proc.path", "The path does not exist");
        }
    }
}

