/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.Libc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SolarisCentralProcessor.class);

    public SolarisCentralProcessor() {
        this.initVars();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("cpu_info", -1, null);
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            this.setVendor(KstatUtil.kstatDataLookupString(ksp, "vendor_id"));
            this.setName(KstatUtil.kstatDataLookupString(ksp, "brand"));
            this.setStepping(KstatUtil.kstatDataLookupString(ksp, "stepping"));
            this.setModel(KstatUtil.kstatDataLookupString(ksp, "model"));
            this.setFamily(KstatUtil.kstatDataLookupString(ksp, "family"));
        }
        this.setCpu64("64".equals(ExecutingCommand.getFirstAnswer("isainfo -b").trim()));
        this.setProcessorID(this.getProcessorID(this.getStepping(), this.getModel(), this.getFamily()));
    }

    @Override
    protected CentralProcessor.LogicalProcessor[] initProcessorCounts() {
        Map<Integer, Integer> numaNodeMap = this.mapNumaNodes();
        List<LibKstat.Kstat> kstats = KstatUtil.kstatLookupAll("cpu_info", -1, null);
        HashSet<String> chipIDs = new HashSet<String>();
        HashSet<String> coreChipIDs = new HashSet<String>();
        this.logicalProcessorCount = 0;
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        for (LibKstat.Kstat ksp : kstats) {
            if (ksp == null || !KstatUtil.kstatRead(ksp)) continue;
            int procId = logProcs.size();
            String chipId = KstatUtil.kstatDataLookupString(ksp, "chip_id");
            String coreId = KstatUtil.kstatDataLookupString(ksp, "core_id");
            CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(procId, ParseUtil.parseIntOrDefault(coreId, 0), ParseUtil.parseIntOrDefault(chipId, 0), numaNodeMap.getOrDefault(procId, 0));
            logProcs.add(logProc);
            coreChipIDs.add(coreId + ":" + chipId);
            chipIDs.add(chipId);
        }
        this.logicalProcessorCount = logProcs.size();
        if (this.logicalProcessorCount < 1) {
            LOG.error("Couldn't find logical processor count. Assuming 1.");
            this.logicalProcessorCount = 1;
            logProcs.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        this.physicalPackageCount = chipIDs.size();
        if (this.physicalPackageCount < 1) {
            LOG.error("Couldn't find physical package count. Assuming 1.");
            this.physicalPackageCount = 1;
        }
        this.physicalProcessorCount = coreChipIDs.size();
        if (this.physicalProcessorCount < 1) {
            LOG.error("Couldn't find physical processor count. Assuming 1.");
            this.physicalProcessorCount = 1;
        }
        return logProcs.toArray(new CentralProcessor.LogicalProcessor[0]);
    }

    private Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> numaNodeMap = new HashMap<Integer, Integer>();
        List<String> lgrpinfo = ExecutingCommand.runNative("lgrpinfo -c leaves");
        int lgroup = 0;
        for (String line : lgrpinfo) {
            String[] cpuList;
            if (line.startsWith("lgroup")) {
                lgroup = ParseUtil.getFirstIntValue(line);
                continue;
            }
            if (!line.contains("CPUs:")) continue;
            for (String cpu : cpuList = ParseUtil.whitespaces.split(line.split(":")[1])) {
                if (cpu.contains("-")) {
                    int first = ParseUtil.getFirstIntValue(cpu);
                    int last = ParseUtil.getNthIntValue(line, 2);
                    for (int i = first; i <= last; ++i) {
                        numaNodeMap.put(i, lgroup);
                    }
                    continue;
                }
                numaNodeMap.put(ParseUtil.parseIntOrDefault(cpu, 0), lgroup);
            }
        }
        return numaNodeMap;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        long[][] procTicks = this.getProcessorCpuLoadTicks();
        int i = 0;
        while (i < ticks.length) {
            for (long[] procTick : procTicks) {
                int n = i;
                ticks[n] = ticks[n] + procTick[i];
            }
            int n = i++;
            ticks[n] = ticks[n] / (long)procTicks.length;
        }
        return ticks;
    }

    @Override
    public long[] getCurrentFreq() {
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, -1L);
        for (int i = 0; i < freqs.length; ++i) {
            for (LibKstat.Kstat ksp : KstatUtil.kstatLookupAll("cpu_info", i, null)) {
                if (!KstatUtil.kstatRead(ksp)) continue;
                freqs[i] = KstatUtil.kstatDataLookupLong(ksp, "current_clock_Hz");
            }
        }
        return freqs;
    }

    @Override
    public long queryMaxFreq() {
        long max = -1L;
        for (LibKstat.Kstat ksp : KstatUtil.kstatLookupAll("cpu_info", 0, null)) {
            String suppFreq;
            if (!KstatUtil.kstatRead(ksp) || (suppFreq = KstatUtil.kstatDataLookupString(ksp, "supported_frequencies_Hz")).isEmpty()) continue;
            for (String s : suppFreq.split(":")) {
                long freq = ParseUtil.parseLongOrDefault(s, -1L);
                if (max >= freq) continue;
                max = freq;
            }
        }
        return max;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = Libc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        int cpu = -1;
        for (LibKstat.Kstat ksp : KstatUtil.kstatLookupAll("cpu", -1, "sys")) {
            if (++cpu >= ticks.length) break;
            if (!KstatUtil.kstatRead(ksp)) continue;
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_idle");
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_kernel");
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_user");
        }
        return ticks;
    }

    private String getProcessorID(String stepping, String model, String family) {
        List<String> isainfo = ExecutingCommand.runNative("isainfo -v");
        StringBuilder flags = new StringBuilder();
        for (String line : isainfo) {
            if (line.startsWith("32-bit")) break;
            if (line.startsWith("64-bit")) continue;
            flags.append(' ').append(line.trim());
        }
        return this.createProcessorID(stepping, model, family, ParseUtil.whitespaces.split(flags.toString().toLowerCase()));
    }

    @Override
    public long getContextSwitches() {
        long swtch = 0L;
        List<String> kstat = ExecutingCommand.runNative("kstat -p cpu_stat:::/pswitch\\\\|inv_swtch/");
        for (String s : kstat) {
            swtch += ParseUtil.parseLastLong(s, 0L);
        }
        return swtch > 0L ? swtch : -1L;
    }

    @Override
    public long getInterrupts() {
        long intr = 0L;
        List<String> kstat = ExecutingCommand.runNative("kstat -p cpu_stat:::/intr/");
        for (String s : kstat) {
            intr += ParseUtil.parseLastLong(s, 0L);
        }
        return intr > 0L ? intr : -1L;
    }
}

