/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.List;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class LinuxVirtualMemory
extends AbstractVirtualMemory {
    private static final long serialVersionUID = 1L;

    @Override
    public long getSwapUsed() {
        this.updateMemInfo();
        return this.swapUsed;
    }

    @Override
    public long getSwapTotal() {
        this.updateMemInfo();
        return this.swapTotal;
    }

    @Override
    public long getSwapPagesIn() {
        this.updateVmStat();
        return this.swapPagesIn;
    }

    @Override
    public long getSwapPagesOut() {
        this.updateVmStat();
        return this.swapPagesOut;
    }

    private void updateMemInfo() {
        if (System.nanoTime() - this.lastSwapUsageNanos > 300000000L) {
            long swapFree = 0L;
            List<String> memInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/meminfo");
            for (String checkLine : memInfo) {
                String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
                if (memorySplit.length <= 1) continue;
                switch (memorySplit[0]) {
                    case "SwapTotal:": {
                        this.swapTotal = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SwapFree:": {
                        swapFree = this.parseMeminfo(memorySplit);
                        break;
                    }
                }
            }
            this.swapUsed = this.swapTotal - swapFree;
            this.lastSwapUsageNanos = System.nanoTime();
        }
    }

    private void updateVmStat() {
        if (System.nanoTime() - this.lastSwapPagesNanos > 300000000L) {
            List<String> vmStat = FileUtil.readFile(ProcUtil.getProcPath() + "/vmstat");
            for (String checkLine : vmStat) {
                String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
                if (memorySplit.length <= 1) continue;
                switch (memorySplit[0]) {
                    case "pgpgin": {
                        this.swapPagesIn = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                        break;
                    }
                    case "pgpgout": {
                        this.swapPagesOut = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                        break;
                    }
                }
            }
            this.lastSwapPagesNanos = System.nanoTime();
        }
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }
}

