/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.List;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.linux.LinuxBaseboard;
import oshi.hardware.platform.linux.LinuxFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

final class LinuxComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;

    LinuxComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null && !this.queryManufacturerFromSysfs() && !this.queryManufacturerFromProcCpu()) {
            this.manufacturer = "unknown";
        }
        return super.getManufacturer();
    }

    @Override
    public String getModel() {
        if (!(this.model != null || this.queryModelFromSysfs() || this.queryModelFromDeviceTree() || this.queryModelAndSerialFromLshw())) {
            this.model = "unknown";
        }
        return super.getModel();
    }

    @Override
    public String getSerialNumber() {
        if (!(this.serialNumber != null || this.querySerialFromSysfs() || this.querySerialFromDmiDecode() || this.querySerialFromLshal() || this.queryModelAndSerialFromLshw())) {
            this.serialNumber = "unknown";
        }
        return this.serialNumber;
    }

    @Override
    public Firmware getFirmware() {
        if (this.firmware == null) {
            this.firmware = new LinuxFirmware();
        }
        return this.firmware;
    }

    @Override
    public Baseboard getBaseboard() {
        if (this.baseboard == null) {
            this.baseboard = new LinuxBaseboard();
        }
        return this.baseboard;
    }

    private boolean queryManufacturerFromSysfs() {
        String sysVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/sys_vendor").trim();
        if (!sysVendor.isEmpty()) {
            this.manufacturer = sysVendor;
            return true;
        }
        return false;
    }

    private boolean queryManufacturerFromProcCpu() {
        List<String> cpuInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/cpuinfo");
        for (String line : cpuInfo) {
            if (!line.startsWith("CPU implementer")) continue;
            int part = ParseUtil.parseLastInt(line, 0);
            switch (part) {
                case 65: {
                    this.manufacturer = "ARM";
                    return true;
                }
                case 66: {
                    this.manufacturer = "Broadcom";
                    return true;
                }
                case 67: {
                    this.manufacturer = "Cavium";
                    return true;
                }
                case 68: {
                    this.manufacturer = "DEC";
                    return true;
                }
                case 78: {
                    this.manufacturer = "Nvidia";
                    return true;
                }
                case 80: {
                    this.manufacturer = "APM";
                    return true;
                }
                case 81: {
                    this.manufacturer = "Qualcomm";
                    return true;
                }
                case 83: {
                    this.manufacturer = "Samsung";
                    return true;
                }
                case 86: {
                    this.manufacturer = "Marvell";
                    return true;
                }
                case 102: {
                    this.manufacturer = "Faraday";
                    return true;
                }
                case 105: {
                    this.manufacturer = "Intel";
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean queryModelFromSysfs() {
        String productName = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_name").trim();
        String productVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_version").trim();
        if (productName.isEmpty()) {
            if (!productVersion.isEmpty()) {
                this.model = productVersion;
                return true;
            }
        } else {
            if (!productVersion.isEmpty() && !"None".equals(productVersion)) {
                this.model = productName + " (version: " + productVersion + ")";
                return true;
            }
            this.model = productName;
            return true;
        }
        return false;
    }

    private boolean queryModelFromDeviceTree() {
        String modelStr = FileUtil.getStringFromFile("/sys/firmware/devicetree/base/model");
        if (!modelStr.isEmpty()) {
            this.model = modelStr.replace("Machine: ", "");
            return true;
        }
        return false;
    }

    private boolean querySerialFromSysfs() {
        String serialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_serial");
        if (serialNumber.isEmpty() || "None".equals(serialNumber)) {
            serialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial");
            if (serialNumber.isEmpty() || "None".equals(serialNumber)) {
                return false;
            }
            this.serialNumber = serialNumber;
        }
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    private boolean querySerialFromDmiDecode() {
        String marker = "Serial Number:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            if (!checkLine.contains(marker)) continue;
            this.serialNumber = checkLine.split(marker)[1].trim();
            break;
        }
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    private boolean querySerialFromLshal() {
        String marker = "system.hardware.serial =";
        for (String checkLine : ExecutingCommand.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            this.serialNumber = ParseUtil.getSingleQuoteStringValue(checkLine);
            break;
        }
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    private boolean queryModelAndSerialFromLshw() {
        String serialMarker = "serial:";
        String modelMarker = "product:";
        for (String checkLine : ExecutingCommand.runNative("lshw -C system")) {
            if (checkLine.contains(serialMarker)) {
                this.serialNumber = checkLine.split(serialMarker)[1].trim();
                continue;
            }
            if (!checkLine.contains(modelMarker)) continue;
            this.model = checkLine.split(modelMarker)[1].trim();
        }
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }
}

