/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.Libc;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxCentralProcessor.class);
    private static final String CPUFREQ_PATH = "/sys/devices/system/cpu/cpu";

    public LinuxCentralProcessor() {
        this.initVars();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        String armStepping = "";
        String[] flags = new String[]{};
        List<String> cpuInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/cpuinfo");
        for (String line : cpuInfo) {
            String[] splitLine = ParseUtil.whitespacesColonWhitespace.split(line);
            if (splitLine.length < 2) continue;
            switch (splitLine[0]) {
                case "vendor_id": 
                case "CPU implementer": {
                    this.setVendor(splitLine[1]);
                    break;
                }
                case "model name": {
                    this.setName(splitLine[1]);
                    break;
                }
                case "flags": {
                    flags = splitLine[1].toLowerCase().split(" ");
                    boolean found = false;
                    for (String flag : flags) {
                        if (!"lm".equals(flag)) continue;
                        found = true;
                        break;
                    }
                    this.setCpu64(found);
                    break;
                }
                case "stepping": {
                    this.setStepping(splitLine[1]);
                    break;
                }
                case "CPU variant": {
                    armStepping = "r" + splitLine[1] + armStepping;
                    break;
                }
                case "CPU revision": {
                    armStepping = armStepping + "p" + splitLine[1];
                    break;
                }
                case "model": 
                case "CPU part": {
                    this.setModel(splitLine[1]);
                    break;
                }
                case "cpu family": 
                case "CPU architecture": {
                    this.setFamily(splitLine[1]);
                    break;
                }
            }
        }
        this.setProcessorID(this.getProcessorID(this.getVendor(), this.getStepping(), this.getModel(), this.getFamily(), flags));
        if (this.getVendor().startsWith("0x")) {
            List<String> lscpu = ExecutingCommand.runNative("lscpu");
            for (String line : lscpu) {
                if (!line.startsWith("Architecture:")) continue;
                this.setVendor(line.replace("Architecture:", "").trim());
            }
        }
    }

    @Override
    protected CentralProcessor.LogicalProcessor[] initProcessorCounts() {
        Map<Integer, Integer> numaNodeMap = this.mapNumaNodes();
        List<String> procCpu = FileUtil.readFile(ProcUtil.getProcPath() + "/cpuinfo");
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        int currentProcessor = 0;
        int currentCore = 0;
        int currentPackage = 0;
        boolean first = true;
        for (String cpu : procCpu) {
            if (cpu.startsWith("processor")) {
                if (!first) {
                    logProcs.add(new CentralProcessor.LogicalProcessor(currentProcessor, currentCore, currentPackage, numaNodeMap.getOrDefault(currentProcessor, 0)));
                } else {
                    first = false;
                }
                currentProcessor = ParseUtil.parseLastInt(cpu, 0);
                continue;
            }
            if (cpu.startsWith("core id") || cpu.startsWith("cpu number")) {
                currentCore = ParseUtil.parseLastInt(cpu, 0);
                continue;
            }
            if (!cpu.startsWith("physical id")) continue;
            currentPackage = ParseUtil.parseLastInt(cpu, 0);
        }
        logProcs.add(new CentralProcessor.LogicalProcessor(currentProcessor, currentCore, currentPackage, numaNodeMap.getOrDefault(currentProcessor, 0)));
        HashSet<String> physProcPkgs = new HashSet<String>();
        HashSet<Integer> physPkgs = new HashSet<Integer>();
        for (CentralProcessor.LogicalProcessor logProc : logProcs) {
            int pkg = logProc.getPhysicalPackageNumber();
            physProcPkgs.add(logProc.getPhysicalProcessorNumber() + ":" + pkg);
            physPkgs.add(pkg);
        }
        this.logicalProcessorCount = logProcs.size();
        this.physicalProcessorCount = physProcPkgs.size();
        this.physicalPackageCount = physPkgs.size();
        return logProcs.toArray(new CentralProcessor.LogicalProcessor[0]);
    }

    private Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> numaNodeMap = new HashMap<Integer, Integer>();
        List<String> lscpu = ExecutingCommand.runNative("lscpu -p=cpu,node");
        for (String line : lscpu) {
            String[] split;
            if (line.startsWith("#") || (split = line.split(",")).length != 2) continue;
            numaNodeMap.put(ParseUtil.parseIntOrDefault(split[0], 0), ParseUtil.parseIntOrDefault(split[1], 0));
        }
        return numaNodeMap;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        long[] ticks = ProcUtil.readSystemCpuLoadTicks();
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            ticks[i] = ticks[i] * 1000L / hz;
        }
        return ticks;
    }

    @Override
    public long[] getCurrentFreq() {
        int i;
        long[] freqs = new long[this.getLogicalProcessorCount()];
        long max = 0L;
        for (i = 0; i < freqs.length; ++i) {
            freqs[i] = FileUtil.getLongFromFile(CPUFREQ_PATH + i + "/cpufreq/scaling_cur_freq");
            if (freqs[i] == 0L) {
                freqs[i] = FileUtil.getLongFromFile(CPUFREQ_PATH + i + "/cpufreq/cpuinfo_cur_freq");
            }
            if (max >= freqs[i]) continue;
            max = freqs[i];
        }
        if (max > 0L) {
            i = 0;
            while (i < freqs.length) {
                int n = i++;
                freqs[n] = freqs[n] * 1000L;
            }
            return freqs;
        }
        Arrays.fill(freqs, -1L);
        List<String> cpuInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/cpuinfo");
        int proc = 0;
        for (String s : cpuInfo) {
            if (!s.toLowerCase().contains("cpu mhz")) continue;
            freqs[proc] = (long)(ParseUtil.parseLastDouble(s, 0.0) * 1000000.0);
            if (++proc < freqs.length) continue;
            break;
        }
        return freqs;
    }

    @Override
    public long queryMaxFreq() {
        long max = 0L;
        for (int i = 0; i < this.getLogicalProcessorCount(); ++i) {
            long freq = FileUtil.getLongFromFile(CPUFREQ_PATH + i + "/cpufreq/scaling_max_freq");
            if (freq == 0L) {
                freq = FileUtil.getLongFromFile(CPUFREQ_PATH + i + "/cpufreq/cpuinfo_max_freq");
            }
            if (max >= freq) continue;
            max = freq;
        }
        if (max > 0L) {
            return max * 1000L;
        }
        return -1L;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = Libc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        int cpu = 0;
        List<String> procStat = FileUtil.readFile(ProcUtil.getProcPath() + "/stat");
        for (String stat : procStat) {
            if (!stat.startsWith("cpu") || stat.startsWith("cpu ")) continue;
            String[] tickArr = ParseUtil.whitespaces.split(stat);
            if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
                return ticks;
            }
            for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
                ticks[cpu][i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
            }
            if (++cpu < this.logicalProcessorCount) continue;
            break;
        }
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            for (int j = 0; j < ticks[i].length; ++j) {
                ticks[i][j] = ticks[i][j] * 1000L / hz;
            }
        }
        return ticks;
    }

    private String getProcessorID(String vendor, String stepping, String model, String family, String[] flags) {
        boolean procInfo = false;
        String marker = "Processor Information";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t 4")) {
            if (!procInfo && checkLine.contains(marker)) {
                marker = "ID:";
                procInfo = true;
                continue;
            }
            if (!procInfo || !checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        marker = "eax=";
        for (String checkLine : ExecutingCommand.runNative("cpuid -1r")) {
            if (!checkLine.contains(marker) || !checkLine.trim().startsWith("0x00000001")) continue;
            String eax = "";
            String edx = "";
            for (String register : ParseUtil.whitespaces.split(checkLine)) {
                if (register.startsWith("eax=")) {
                    eax = ParseUtil.removeMatchingString(register, "eax=0x");
                    continue;
                }
                if (!register.startsWith("edx=")) continue;
                edx = ParseUtil.removeMatchingString(register, "edx=0x");
            }
            return edx + eax;
        }
        if (vendor.startsWith("0x")) {
            return this.createMIDR(vendor, stepping, model, family) + "00000000";
        }
        return this.createProcessorID(stepping, model, family, flags);
    }

    private String createMIDR(String vendor, String stepping, String model, String family) {
        int midrBytes = 0;
        if (stepping.startsWith("r") && stepping.contains("p")) {
            String[] rev = stepping.substring(1).split("p");
            midrBytes |= ParseUtil.parseLastInt(rev[1], 0);
            midrBytes |= ParseUtil.parseLastInt(rev[0], 0) << 20;
        }
        midrBytes |= ParseUtil.parseLastInt(model, 0) << 4;
        midrBytes |= ParseUtil.parseLastInt(family, 0) << 16;
        return String.format("%08X", midrBytes |= ParseUtil.parseLastInt(vendor, 0) << 24);
    }

    @Override
    public long getContextSwitches() {
        List<String> procStat = FileUtil.readFile(ProcUtil.getProcPath() + "/stat");
        for (String stat : procStat) {
            String[] ctxtArr;
            if (!stat.startsWith("ctxt ") || (ctxtArr = ParseUtil.whitespaces.split(stat)).length != 2) continue;
            return ParseUtil.parseLongOrDefault(ctxtArr[1], 0L);
        }
        return -1L;
    }

    @Override
    public long getInterrupts() {
        List<String> procStat = FileUtil.readFile(ProcUtil.getProcPath() + "/stat");
        for (String stat : procStat) {
            String[] intrArr;
            if (!stat.startsWith("intr ") || (intrArr = ParseUtil.whitespaces.split(stat)).length <= 2) continue;
            return ParseUtil.parseLongOrDefault(intrArr[1], 0L);
        }
        return -1L;
    }
}

