/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.User32;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.common.AbstractOSVersionInfoEx;
import oshi.util.ParseUtil;
import oshi.util.StringUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsOSVersionInfoEx
extends AbstractOSVersionInfoEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSVersionInfoEx.class);

    public WindowsOSVersionInfoEx() {
        this.init();
    }

    private void init() {
        WmiUtil.WmiQuery<OSVersionProperty> osVersionQuery = WmiUtil.createQuery("Win32_OperatingSystem", OSVersionProperty.class);
        WmiUtil.WmiResult<OSVersionProperty> versionInfo = WmiUtil.queryWMI(osVersionQuery);
        if (versionInfo.getResultCount() < 1) {
            LOG.warn("No version data available.");
            this.setVersion(System.getProperty("os.version"));
            this.setCodeName("");
            this.setBuildNumber("");
        } else {
            int suiteMask = (int)((Long)versionInfo.get(OSVersionProperty.SUITEMASK).get(0)).longValue();
            this.setVersion(this.parseVersion(versionInfo, suiteMask));
            this.setCodeName(this.parseCodeName(suiteMask));
            this.setBuildNumber((String)versionInfo.get(OSVersionProperty.BUILDNUMBER).get(0));
            LOG.debug("Initialized OSVersionInfoEx");
        }
    }

    private String parseVersion(WmiUtil.WmiResult<OSVersionProperty> versionInfo, int suiteMask) {
        String sp;
        boolean ntWorkstation;
        String version = System.getProperty("os.version");
        String[] verSplit = ((String)versionInfo.get(OSVersionProperty.VERSION).get(0)).split("\\D");
        int major = verSplit.length > 0 ? ParseUtil.parseIntOrDefault(verSplit[0], 0) : 0;
        int minor = verSplit.length > 1 ? ParseUtil.parseIntOrDefault(verSplit[1], 0) : 0;
        boolean bl = ntWorkstation = (Long)versionInfo.get(OSVersionProperty.PRODUCTTYPE).get(0) == 1L;
        if (major == 10) {
            if (minor == 0) {
                version = ntWorkstation ? "10" : "Server 2016";
            }
        } else if (major == 6) {
            if (minor == 3) {
                version = ntWorkstation ? "8.1" : "Server 2012 R2";
            } else if (minor == 2) {
                version = ntWorkstation ? "8" : "Server 2012";
            } else if (minor == 1) {
                version = ntWorkstation ? "7" : "Server 2008 R2";
            } else if (minor == 0) {
                version = ntWorkstation ? "Vista" : "Server 2008";
            }
        } else if (major == 5) {
            if (minor == 2) {
                version = (suiteMask & 0x8000) != 0 ? "Home Server" : (ntWorkstation ? "XP" : (User32.INSTANCE.GetSystemMetrics(89) != 0 ? "Server 2003" : "Server 2003 R2"));
            } else if (minor == 1) {
                version = "XP";
            } else if (minor == 0) {
                version = "2000";
            }
        }
        if (!(sp = (String)versionInfo.get(OSVersionProperty.CSDVERSION).get(0)).isEmpty() && !"unknown".equals(sp)) {
            version = version + " " + sp.replace("Service Pack ", "SP");
        }
        return version;
    }

    private String parseCodeName(int suiteMask) {
        ArrayList<String> suites = new ArrayList<String>();
        if ((suiteMask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((suiteMask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((suiteMask & 8) != 0) {
            suites.add("Communication Server");
        }
        if ((suiteMask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((suiteMask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((suiteMask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((suiteMask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((suiteMask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        return StringUtil.join(",", suites);
    }

    static enum OSVersionProperty implements WmiUtil.WmiProperty
    {
        VERSION(WmiUtil.ValueType.STRING),
        PRODUCTTYPE(WmiUtil.ValueType.UINT32),
        BUILDNUMBER(WmiUtil.ValueType.STRING),
        CSDVERSION(WmiUtil.ValueType.STRING),
        SUITEMASK(WmiUtil.ValueType.UINT32);

        private WmiUtil.ValueType type;

        private OSVersionProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }
}

