/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.Kernel32;
import oshi.jna.platform.windows.Pdh;
import oshi.jna.platform.windows.WinPerf;
import oshi.jna.platform.windows.Wtsapi32;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.windows.WindowsFileSystem;
import oshi.software.os.windows.WindowsNetworkParams;
import oshi.software.os.windows.WindowsOSVersionInfoEx;
import oshi.util.FormatUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    private static final WmiProperty[] PROCESS_PROPERTIES;
    private static final String[] PROCESS_STRINGS;
    private static final WmiUtil.ValueType[] PROCESS_TYPES;
    private int perfDataBufferSize = 8192;
    private int processIndex;
    private String processIndexStr;
    private int priorityBaseOffset;
    private int elapsedTimeOffset;
    private int idProcessOffset;
    private int creatingProcessIdOffset;
    private int ioReadOffset;
    private int ioWriteOffset;
    private int workingSetPrivateOffset;
    private final Map<Integer, OSProcess> processMap = new HashMap<Integer, OSProcess>();

    public WindowsOperatingSystem() {
        this.manufacturer = "Microsoft";
        this.family = "Windows";
        this.version = new WindowsOSVersionInfoEx();
        this.initRegistry();
        this.initBitness();
    }

    private void initRegistry() {
        WinDef.DWORDByReference index = new WinDef.DWORDByReference();
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "Process", index);
        this.processIndex = index.getValue().intValue();
        this.processIndexStr = Integer.toString(this.processIndex);
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "Priority Base", index);
        int priorityBaseIndex = index.getValue().intValue();
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "Elapsed Time", index);
        int elapsedTimeIndex = index.getValue().intValue();
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "ID Process", index);
        int idProcessIndex = index.getValue().intValue();
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "Creating Process ID", index);
        int creatingProcessIdIndex = index.getValue().intValue();
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "IO Read Bytes/sec", index);
        int ioReadIndex = index.getValue().intValue();
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "IO Write Bytes/sec", index);
        int ioWriteIndex = index.getValue().intValue();
        Pdh.INSTANCE.PdhLookupPerfIndexByName(null, "Working Set - Private", index);
        int workingSetPrivateIndex = index.getValue().intValue();
        IntByReference lpcbData = new IntByReference(this.perfDataBufferSize);
        Memory pPerfData = new Memory((long)this.perfDataBufferSize);
        while (234 == Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, this.processIndexStr, 0, null, (Pointer)pPerfData, lpcbData)) {
            this.perfDataBufferSize += 4096;
            lpcbData.setValue(this.perfDataBufferSize);
            pPerfData = new Memory((long)this.perfDataBufferSize);
        }
        WinPerf.PERF_DATA_BLOCK perfData = new WinPerf.PERF_DATA_BLOCK(pPerfData.share(0L));
        long perfObjectOffset = perfData.HeaderLength;
        for (int obj = 0; obj < perfData.NumObjectTypes; ++obj) {
            WinPerf.PERF_OBJECT_TYPE perfObject = new WinPerf.PERF_OBJECT_TYPE(pPerfData.share(perfObjectOffset));
            long perfCounterOffset = perfObjectOffset + (long)perfObject.HeaderLength;
            if (perfObject.ObjectNameTitleIndex == this.processIndex) {
                for (int counter = 0; counter < perfObject.NumCounters; ++counter) {
                    WinPerf.PERF_COUNTER_DEFINITION perfCounter = new WinPerf.PERF_COUNTER_DEFINITION(pPerfData.share(perfCounterOffset));
                    if (perfCounter.CounterNameTitleIndex == priorityBaseIndex) {
                        this.priorityBaseOffset = perfCounter.CounterOffset;
                    } else if (perfCounter.CounterNameTitleIndex == elapsedTimeIndex) {
                        this.elapsedTimeOffset = perfCounter.CounterOffset;
                    } else if (perfCounter.CounterNameTitleIndex == creatingProcessIdIndex) {
                        this.creatingProcessIdOffset = perfCounter.CounterOffset;
                    } else if (perfCounter.CounterNameTitleIndex == idProcessIndex) {
                        this.idProcessOffset = perfCounter.CounterOffset;
                    } else if (perfCounter.CounterNameTitleIndex == ioReadIndex) {
                        this.ioReadOffset = perfCounter.CounterOffset;
                    } else if (perfCounter.CounterNameTitleIndex == ioWriteIndex) {
                        this.ioWriteOffset = perfCounter.CounterOffset;
                    } else if (perfCounter.CounterNameTitleIndex == workingSetPrivateIndex) {
                        this.workingSetPrivateOffset = perfCounter.CounterOffset;
                    }
                    perfCounterOffset += (long)perfCounter.ByteLength;
                }
                break;
            }
            perfObjectOffset += (long)perfObject.TotalByteLength;
        }
    }

    private void initBitness() {
        if (this.bitness < 64) {
            this.bitness = System.getenv("ProgramFiles(x86)") != null ? 64 : WmiUtil.selectUint32From(null, "Win32_Processor", "AddressWidth", null).intValue();
        }
    }

    @Override
    public FileSystem getFileSystem() {
        return new WindowsFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        List<OSProcess> procList = this.processMapToList(null);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSProcess[] getChildProcesses(int parentPid, int limit, OperatingSystem.ProcessSort sort) {
        HashSet<Integer> childPids = new HashSet<Integer>();
        Tlhelp32.PROCESSENTRY32.ByReference processEntry = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE snapshot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            while (Kernel32.INSTANCE.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)processEntry)) {
                if (processEntry.th32ParentProcessID.intValue() != parentPid) continue;
                childPids.add(processEntry.th32ProcessID.intValue());
            }
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(snapshot);
        }
        List<OSProcess> procList = this.getProcesses(childPids);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        HashSet<Integer> pids = new HashSet<Integer>(1);
        pids.add(pid);
        List<OSProcess> procList = this.processMapToList(pids);
        return procList.isEmpty() ? null : procList.get(0);
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        return this.processMapToList(pids);
    }

    private List<OSProcess> processMapToList(Collection<Integer> pids) {
        OSProcess proc;
        int pid;
        this.updateProcessMapFromRegistry(pids);
        LinkedList<String> groupList = new LinkedList<String>();
        LinkedList<String> groupIDList = new LinkedList<String>();
        int myPid = this.getProcessId();
        PointerByReference ppProcessInfo = new PointerByReference();
        IntByReference pCount = new IntByReference(0);
        if (!Wtsapi32.INSTANCE.WTSEnumerateProcessesEx(Wtsapi32.WTS_CURRENT_SERVER_HANDLE, new IntByReference(1), -2, ppProcessInfo, pCount)) {
            LOG.error("Failed to enumerate Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return new LinkedList<OSProcess>();
        }
        Pointer pProcessInfo = ppProcessInfo.getValue();
        Wtsapi32.WTS_PROCESS_INFO_EX processInfoRef = new Wtsapi32.WTS_PROCESS_INFO_EX(pProcessInfo);
        Wtsapi32.WTS_PROCESS_INFO_EX[] processInfo = (Wtsapi32.WTS_PROCESS_INFO_EX[])processInfoRef.toArray(pCount.getValue());
        LinkedList<OSProcess> tempProcessList = new LinkedList<OSProcess>();
        for (Wtsapi32.WTS_PROCESS_INFO_EX procInfo : processInfo) {
            pid = procInfo.ProcessId;
            proc = null;
            if (this.processMap.isEmpty()) {
                if (pids != null && !pids.contains(pid)) continue;
                proc = new OSProcess();
                proc.setProcessID(pid);
                proc.setName(procInfo.pProcessName);
            } else {
                proc = this.processMap.get(pid);
                if (proc == null || pids != null && !pids.contains(pid)) continue;
            }
            if (pid == myPid) {
                String cwd = new File(".").getAbsolutePath();
                proc.setCurrentWorkingDirectory(cwd.isEmpty() ? "" : cwd.substring(0, cwd.length() - 1));
            }
            proc.setKernelTime(procInfo.KernelTime.getValue() / 10000L);
            proc.setUserTime(procInfo.UserTime.getValue() / 10000L);
            WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, proc.getProcessID());
            if (pHandle != null) {
                proc.setPath(Kernel32Util.QueryFullProcessImageName((WinNT.HANDLE)pHandle, (int)0));
                WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
                if (Advapi32.INSTANCE.OpenProcessToken(pHandle, 10, phToken)) {
                    Advapi32Util.Account account = Advapi32Util.getTokenAccount((WinNT.HANDLE)phToken.getValue());
                    proc.setUser(account.name);
                    proc.setUserID(account.sidString);
                    if (pids != null) {
                        Advapi32Util.Account[] accounts = Advapi32Util.getTokenGroups((WinNT.HANDLE)phToken.getValue());
                        groupList.clear();
                        groupIDList.clear();
                        for (Advapi32Util.Account a : accounts) {
                            groupList.add(a.name);
                            groupIDList.add(a.sidString);
                        }
                        proc.setGroup(FormatUtil.join((CharSequence)",", groupList));
                        proc.setGroupID(FormatUtil.join((CharSequence)",", groupIDList));
                    }
                } else {
                    int error = Kernel32.INSTANCE.GetLastError();
                    if (error != 5) {
                        LOG.error("Failed to get process token for process {}: {}", (Object)proc.getProcessID(), (Object)Kernel32.INSTANCE.GetLastError());
                    }
                }
            }
            Kernel32.INSTANCE.CloseHandle(pHandle);
            proc.setState(OSProcess.State.RUNNING);
            proc.setThreadCount(procInfo.NumberOfThreads);
            proc.setVirtualSize((long)procInfo.PagefileUsage & 0xFFFFFFFFL);
            proc.setOpenFiles(procInfo.HandleCount);
            tempProcessList.add(proc);
        }
        if (!Wtsapi32.INSTANCE.WTSFreeMemoryEx(1, pProcessInfo, pCount.getValue())) {
            LOG.error("Failed to Free Memory for Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return new LinkedList<OSProcess>();
        }
        HashSet<Integer> emptyCommandLines = new HashSet<Integer>();
        for (OSProcess cachedProcess : tempProcessList) {
            if (!cachedProcess.getCommandLine().isEmpty()) continue;
            emptyCommandLines.add(cachedProcess.getProcessID());
        }
        if (!emptyCommandLines.isEmpty()) {
            StringBuilder query = new StringBuilder("WHERE ");
            for (Integer pid2 : emptyCommandLines) {
                query.append(String.format("ProcessID=%d OR ", pid2));
            }
            query.setLength(query.length() - 3);
            Map<String, List<Object>> commandLineProcs = WmiUtil.selectObjectsFrom(null, "Win32_Process", PROCESS_STRINGS, query.toString(), PROCESS_TYPES);
            for (int p = 0; p < commandLineProcs.get(WmiProperty.PROCESSID.name()).size(); ++p) {
                pid = ((Long)commandLineProcs.get(WmiProperty.PROCESSID.name()).get(p)).intValue();
                if (!this.processMap.containsKey(pid)) continue;
                proc = this.processMap.get(pid);
                proc.setCommandLine((String)commandLineProcs.get(WmiProperty.COMMANDLINE.name()).get(p));
            }
        }
        ArrayList<OSProcess> procList = new ArrayList<OSProcess>(tempProcessList.size());
        for (OSProcess proc2 : tempProcessList) {
            try {
                procList.add((OSProcess)proc2.clone());
            }
            catch (CloneNotSupportedException e) {
                LOG.error("Unable to clone process ID {}", (Object)proc2.getProcessID());
            }
        }
        return procList;
    }

    private void updateProcessMapFromRegistry(Collection<Integer> pids) {
        LinkedList<Integer> pidsToKeep = new LinkedList<Integer>();
        IntByReference lpcbData = new IntByReference(this.perfDataBufferSize);
        Memory pPerfData = new Memory((long)this.perfDataBufferSize);
        while (234 == Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, this.processIndexStr, 0, null, (Pointer)pPerfData, lpcbData)) {
            this.perfDataBufferSize += 4096;
            lpcbData.setValue(this.perfDataBufferSize);
            pPerfData = new Memory((long)this.perfDataBufferSize);
        }
        WinPerf.PERF_DATA_BLOCK perfData = new WinPerf.PERF_DATA_BLOCK(pPerfData.share(0L));
        long perfTime100nSec = perfData.PerfTime100nSec.getValue();
        long now = System.currentTimeMillis();
        long perfObjectOffset = perfData.HeaderLength;
        for (int obj = 0; obj < perfData.NumObjectTypes; ++obj) {
            WinPerf.PERF_OBJECT_TYPE perfObject = new WinPerf.PERF_OBJECT_TYPE(pPerfData.share(perfObjectOffset));
            if (perfObject.ObjectNameTitleIndex == this.processIndex) {
                long perfInstanceOffset = perfObjectOffset + (long)perfObject.DefinitionLength;
                WinPerf.PERF_COUNTER_BLOCK perfCounterBlock = null;
                for (int inst = 0; inst < perfObject.NumInstances - 1; ++inst) {
                    WinPerf.PERF_INSTANCE_DEFINITION perfInstance = new WinPerf.PERF_INSTANCE_DEFINITION(pPerfData.share(perfInstanceOffset));
                    long perfCounterBlockOffset = perfInstanceOffset + (long)perfInstance.ByteLength;
                    int pid = pPerfData.getInt(perfCounterBlockOffset + (long)this.idProcessOffset);
                    if (pids == null || pids.contains(pid)) {
                        pidsToKeep.add(pid);
                        OSProcess proc = null;
                        if (this.processMap.containsKey(pid)) {
                            proc = this.processMap.get(pid);
                        }
                        long upTime = (perfTime100nSec - pPerfData.getLong(perfCounterBlockOffset + (long)this.elapsedTimeOffset)) / 10000L;
                        long startTime = now - upTime;
                        if (proc == null || Math.abs(startTime - proc.getStartTime()) > 200L) {
                            proc = new OSProcess();
                            proc.setProcessID(pid);
                            proc.setUpTime(upTime);
                            proc.setStartTime(startTime);
                            proc.setName(pPerfData.getWideString(perfInstanceOffset + (long)perfInstance.NameOffset));
                            this.processMap.put(pid, proc);
                        }
                        proc.setBytesRead(pPerfData.getLong(perfCounterBlockOffset + (long)this.ioReadOffset));
                        proc.setBytesWritten(pPerfData.getLong(perfCounterBlockOffset + (long)this.ioWriteOffset));
                        proc.setResidentSetSize(pPerfData.getLong(perfCounterBlockOffset + (long)this.workingSetPrivateOffset));
                        proc.setParentProcessID(pPerfData.getInt(perfCounterBlockOffset + (long)this.creatingProcessIdOffset));
                        proc.setPriority(pPerfData.getInt(perfCounterBlockOffset + (long)this.priorityBaseOffset));
                    }
                    perfCounterBlock = new WinPerf.PERF_COUNTER_BLOCK(pPerfData.share(perfCounterBlockOffset));
                    perfInstanceOffset = perfCounterBlockOffset + (long)perfCounterBlock.ByteLength;
                }
                break;
            }
            perfObjectOffset += (long)perfObject.TotalByteLength;
        }
        if (pids == null) {
            for (Integer pid : new HashSet<Integer>(this.processMap.keySet())) {
                if (pidsToKeep.contains(pid)) continue;
                this.processMap.remove(pid);
            }
        }
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getProcessCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ProcessCount.intValue();
    }

    @Override
    public int getThreadCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ThreadCount.intValue();
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new WindowsNetworkParams();
    }

    private static void enableDebugPrivilege() {
        WinNT.HANDLEByReference hToken = new WinNT.HANDLEByReference();
        boolean success = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, hToken);
        if (!success) {
            LOG.error("OpenProcessToken failed. Error: {}", (Object)Native.getLastError());
            return;
        }
        WinNT.LUID luid = new WinNT.LUID();
        success = Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", luid);
        if (!success) {
            LOG.error("LookupprivilegeValue failed. Error: {}", (Object)Native.getLastError());
            return;
        }
        WinNT.TOKEN_PRIVILEGES tkp = new WinNT.TOKEN_PRIVILEGES(1);
        tkp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
        success = Advapi32.INSTANCE.AdjustTokenPrivileges(hToken.getValue(), false, tkp, 0, null, null);
        if (!success) {
            LOG.error("AdjustTokenPrivileges failed. Error: {}", (Object)Native.getLastError());
        }
        Kernel32.INSTANCE.CloseHandle(hToken.getValue());
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger(WindowsOperatingSystem.class);
        PROCESS_PROPERTIES = new WmiProperty[]{WmiProperty.PROCESSID, WmiProperty.COMMANDLINE};
        PROCESS_STRINGS = new String[PROCESS_PROPERTIES.length];
        for (i = 0; i < PROCESS_PROPERTIES.length; ++i) {
            WindowsOperatingSystem.PROCESS_STRINGS[i] = PROCESS_PROPERTIES[i].name();
        }
        PROCESS_TYPES = new WmiUtil.ValueType[PROCESS_PROPERTIES.length];
        for (i = 0; i < PROCESS_PROPERTIES.length; ++i) {
            WindowsOperatingSystem.PROCESS_TYPES[i] = PROCESS_PROPERTIES[i].getType();
        }
        WindowsOperatingSystem.enableDebugPrivilege();
    }

    static enum WmiProperty {
        PROCESSID(WmiUtil.ValueType.UINT32),
        COMMANDLINE(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        public WmiUtil.ValueType getType() {
            return this.type;
        }

        private WmiProperty(WmiUtil.ValueType type) {
            this.type = type;
        }
    }
}

