/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.hardware.platform.windows.WindowsComputerSystem;
import oshi.util.platform.windows.PdhUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsCentralProcessor.class);
    private static final byte MAJOR_VERSION = Kernel32.INSTANCE.GetVersion().getLow().byteValue();
    private String[][] pdhCounters = null;
    private String pdhIrqCounter = null;
    private String pdhSoftIrqCounter = null;
    private String pdhContextSwitchesPerSecCounter = null;
    private String pdhInterruptsPerSecCounter = null;

    public WindowsCentralProcessor() {
        this.initVars();
        this.initPdhCounters();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        String cpuRegistryRoot = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\";
        String[] processorIds = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\");
        if (processorIds.length > 0) {
            String cpuRegistryPath = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + processorIds[0];
            this.setVendor(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"VendorIdentifier"));
            this.setName(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"ProcessorNameString"));
            this.setIdentifier(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"Identifier"));
        }
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(sysinfo);
        if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 9 || sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 6) {
            this.setCpu64(true);
        } else if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 0) {
            this.setCpu64(false);
        }
        this.setProcessorID(WmiUtil.selectStringFrom(null, "Win32_Processor", "ProcessorID", null));
    }

    private void initPdhCounters() {
        this.pdhCounters = new String[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        String[] queryName = new String[CentralProcessor.TickType.values().length];
        queryName[CentralProcessor.TickType.IDLE.getIndex()] = "\\Processor(%d)\\%% Processor Time";
        queryName[CentralProcessor.TickType.SYSTEM.getIndex()] = "\\Processor(%d)\\%% Privileged Time";
        queryName[CentralProcessor.TickType.USER.getIndex()] = "\\Processor(%d)\\%% User Time";
        queryName[CentralProcessor.TickType.IRQ.getIndex()] = "\\Processor(%d)\\%% Interrupt Time";
        queryName[CentralProcessor.TickType.SOFTIRQ.getIndex()] = "\\Processor(%d)\\%% DPC Time";
        for (int p = 0; p < this.logicalProcessorCount; ++p) {
            this.pdhCounters[p][CentralProcessor.TickType.IDLE.getIndex()] = String.format(queryName[CentralProcessor.TickType.IDLE.getIndex()], p);
            this.pdhCounters[p][CentralProcessor.TickType.SYSTEM.getIndex()] = String.format(queryName[CentralProcessor.TickType.SYSTEM.getIndex()], p);
            this.pdhCounters[p][CentralProcessor.TickType.USER.getIndex()] = String.format(queryName[CentralProcessor.TickType.USER.getIndex()], p);
            this.pdhCounters[p][CentralProcessor.TickType.IRQ.getIndex()] = String.format(queryName[CentralProcessor.TickType.IRQ.getIndex()], p);
            this.pdhCounters[p][CentralProcessor.TickType.SOFTIRQ.getIndex()] = String.format(queryName[CentralProcessor.TickType.SOFTIRQ.getIndex()], p);
        }
        PdhUtil.addCounter2DArray("pdhCounters", this.pdhCounters);
        this.pdhIrqCounter = "\\Processor(_Total)\\% Interrupt Time";
        this.pdhSoftIrqCounter = "\\Processor(_Total)\\% DPC Time";
        this.pdhContextSwitchesPerSecCounter = "\\System\\Context Switches/sec";
        this.pdhInterruptsPerSecCounter = "\\Processor(_Total)\\Interrupts/sec";
        PdhUtil.addCounter(this.pdhIrqCounter);
        PdhUtil.addCounter(this.pdhSoftIrqCounter);
        PdhUtil.addCounter(this.pdhContextSwitchesPerSecCounter);
        PdhUtil.addCounter(this.pdhInterruptsPerSecCounter);
    }

    @Override
    protected void calculateProcessorCounts() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] processors;
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(sysinfo);
        this.logicalProcessorCount = sysinfo.dwNumberOfProcessors.intValue();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION proc : processors = Kernel32Util.getLogicalProcessorInformation()) {
            if (proc.relationship == 3) {
                ++this.physicalPackageCount;
            }
            if (proc.relationship != 0) continue;
            ++this.physicalProcessorCount;
        }
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        WinBase.FILETIME lpIdleTime = new WinBase.FILETIME();
        WinBase.FILETIME lpKernelTime = new WinBase.FILETIME();
        WinBase.FILETIME lpUserTime = new WinBase.FILETIME();
        if (!Kernel32.INSTANCE.GetSystemTimes(lpIdleTime, lpKernelTime, lpUserTime)) {
            LOG.error("Failed to update system idle/kernel/user times. Error code: {}", (Object)Native.getLastError());
            return ticks;
        }
        ticks[CentralProcessor.TickType.IRQ.getIndex()] = PdhUtil.queryCounter(this.pdhIrqCounter) / 10000L;
        ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] = PdhUtil.queryCounter(this.pdhSoftIrqCounter) / 10000L;
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = lpIdleTime.toDWordLong().longValue() / 10000L;
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = lpKernelTime.toDWordLong().longValue() / 10000L - ticks[CentralProcessor.TickType.IDLE.getIndex()];
        ticks[CentralProcessor.TickType.USER.getIndex()] = lpUserTime.toDWordLong().longValue() / 10000L;
        int n = CentralProcessor.TickType.SYSTEM.getIndex();
        ticks[n] = ticks[n] - (ticks[CentralProcessor.TickType.IRQ.getIndex()] + ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()]);
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        for (int i = 0; i < average.length; ++i) {
            average[i] = -1.0;
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = PdhUtil.queryCounter2DArray("pdhCounters", this.pdhCounters);
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            long[] lArray = ticks[cpu];
            int n = CentralProcessor.TickType.IDLE.getIndex();
            lArray[n] = lArray[n] - (ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] + ticks[cpu][CentralProcessor.TickType.USER.getIndex()]);
            long[] lArray2 = ticks[cpu];
            int n2 = CentralProcessor.TickType.SYSTEM.getIndex();
            lArray2[n2] = lArray2[n2] - (ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] + ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()]);
            long[] lArray3 = ticks[cpu];
            int n3 = CentralProcessor.TickType.IDLE.getIndex();
            lArray3[n3] = lArray3[n3] / 10000L;
            long[] lArray4 = ticks[cpu];
            int n4 = CentralProcessor.TickType.SYSTEM.getIndex();
            lArray4[n4] = lArray4[n4] / 10000L;
            long[] lArray5 = ticks[cpu];
            int n5 = CentralProcessor.TickType.USER.getIndex();
            lArray5[n5] = lArray5[n5] / 10000L;
            long[] lArray6 = ticks[cpu];
            int n6 = CentralProcessor.TickType.IRQ.getIndex();
            lArray6[n6] = lArray6[n6] / 10000L;
            long[] lArray7 = ticks[cpu];
            int n7 = CentralProcessor.TickType.SOFTIRQ.getIndex();
            lArray7[n7] = lArray7[n7] / 10000L;
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        if (MAJOR_VERSION >= 6) {
            return Kernel32.INSTANCE.GetTickCount64() / 1000L;
        }
        return (long)Kernel32.INSTANCE.GetTickCount() / 1000L;
    }

    @Override
    @Deprecated
    public String getSystemSerialNumber() {
        return new WindowsComputerSystem().getSerialNumber();
    }

    @Override
    public long getContextSwitches() {
        return PdhUtil.queryCounter(this.pdhContextSwitchesPerSecCounter) / 10000L;
    }

    @Override
    public long getInterrupts() {
        return PdhUtil.queryCounter(this.pdhInterruptsPerSecCounter) / 10000L;
    }
}

