/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.jna.platform.unix.solaris.LibKstat;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisPowerSource
extends AbstractPowerSource {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SolarisPowerSource.class);
    private static final String[] KSTAT_BATT_MOD = new String[]{null, "battery", "acpi_drv"};
    private static final int KSTAT_BATT_IDX = KstatUtil.kstatLookup(KSTAT_BATT_MOD[1], 0, null) != null ? 1 : (KstatUtil.kstatLookup(KSTAT_BATT_MOD[2], 0, null) != null ? 2 : 0);

    public SolarisPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized SolarisPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        if (KSTAT_BATT_IDX == 0) {
            return new SolarisPowerSource[0];
        }
        LibKstat.Kstat ksp = KstatUtil.kstatLookup(KSTAT_BATT_MOD[KSTAT_BATT_IDX], 0, "battery BIF0");
        if (ksp == null) {
            return new SolarisPowerSource[0];
        }
        long energyFull = KstatUtil.kstatDataLookupLong(ksp, "bif_last_cap");
        if (energyFull == -1L || energyFull <= 0L) {
            energyFull = KstatUtil.kstatDataLookupLong(ksp, "bif_design_cap");
        }
        if (energyFull == -1L || energyFull <= 0L) {
            return new SolarisPowerSource[0];
        }
        ksp = KstatUtil.kstatLookup(KSTAT_BATT_MOD[KSTAT_BATT_IDX], 0, "battery BST0");
        if (ksp == null) {
            return new SolarisPowerSource[0];
        }
        long energyNow = KstatUtil.kstatDataLookupLong(ksp, "bst_rem_cap");
        if (energyNow < 0L) {
            return new SolarisPowerSource[0];
        }
        long powerNow = KstatUtil.kstatDataLookupLong(ksp, "bst_rate");
        if (powerNow == -1L) {
            powerNow = 0L;
        }
        boolean isCharging = (KstatUtil.kstatDataLookupLong(ksp, "bst_state") & 0x10L) > 0L;
        PowerSource[] ps = new SolarisPowerSource[]{new SolarisPowerSource("BAT0", (double)energyNow / (double)energyFull, isCharging ? -2.0 : (powerNow > 0L ? 3600.0 * (double)energyNow / (double)powerNow : -1.0))};
        return ps;
    }
}

