/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.function.Function;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.IOKit;
import oshi.util.MapUtil;
import oshi.util.platform.mac.CfUtil;
import oshi.util.platform.mac.IOKitUtil;

public class MacUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static Map<Long, String> nameMap = new HashMap<Long, String>();
    private static Map<Long, String> vendorMap = new HashMap<Long, String>();
    private static Map<Long, String> vendorIdMap = new HashMap<Long, String>();
    private static Map<Long, String> productIdMap = new HashMap<Long, String>();
    private static Map<Long, String> serialMap = new HashMap<Long, String>();
    private static Map<Long, List<Long>> hubMap = new HashMap<Long, List<Long>>();

    public MacUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = MacUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            MacUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(new MacUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new MacUsbDevice[0]));
            MacUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        Memory buffer = new Memory(128L);
        nameMap.clear();
        vendorMap.clear();
        vendorIdMap.clear();
        productIdMap.clear();
        serialMap.clear();
        hubMap.clear();
        ArrayList<Long> usbControllers = new ArrayList<Long>();
        IntByReference iter = new IntByReference();
        IOKitUtil.getMatchingServices("IOUSBController", iter);
        int device = IOKit.INSTANCE.IOIteratorNext(iter.getValue());
        while (device != 0) {
            LongByReference id = new LongByReference();
            IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(device, id);
            usbControllers.add(id.getValue());
            IOKit.INSTANCE.IORegistryEntryGetName(device, (Pointer)buffer);
            nameMap.put(id.getValue(), buffer.getString(0L));
            CoreFoundation.CFTypeRef ref = IOKit.INSTANCE.IORegistryEntryCreateCFProperty(device, CfUtil.getCFString("locationID"), CfUtil.ALLOCATOR, 0);
            if (ref != null && ref.getPointer() != null) {
                MacUsbDevice.getControllerIdByLocation(id.getValue(), ref);
            }
            CfUtil.release(ref);
            IntByReference childIter = new IntByReference();
            IOKit.INSTANCE.IORegistryEntryGetChildIterator(device, "IOService", childIter);
            int childDevice = IOKit.INSTANCE.IOIteratorNext(childIter.getValue());
            while (childDevice != 0) {
                String serial;
                long productId;
                long vendorId;
                LongByReference childId = new LongByReference();
                IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(childDevice, childId);
                IntByReference parent = new IntByReference();
                IOKit.INSTANCE.IORegistryEntryGetParentEntry(childDevice, "IOUSB", parent);
                LongByReference parentId = new LongByReference();
                if (!IOKit.INSTANCE.IOObjectConformsTo(parent.getValue(), "IOUSBDevice")) {
                    parentId = id;
                } else {
                    IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(parent.getValue(), parentId);
                }
                MapUtil.computeIfAbsent(hubMap, parentId.getValue(), new Function<Long, List<Long>>(){

                    public List<Long> apply(Long k) {
                        return new ArrayList<Long>();
                    }
                }).add(childId.getValue());
                IOKit.INSTANCE.IORegistryEntryGetName(childDevice, (Pointer)buffer);
                nameMap.put(childId.getValue(), buffer.getString(0L));
                String vendor = IOKitUtil.getIORegistryStringProperty(childDevice, "USB Vendor Name");
                if (vendor != null) {
                    vendorMap.put(childId.getValue(), vendor);
                }
                if ((vendorId = IOKitUtil.getIORegistryLongProperty(childDevice, "idVendor")) != 0L) {
                    vendorIdMap.put(childId.getValue(), String.format("%04x", 0xFFFFL & vendorId));
                }
                if ((productId = IOKitUtil.getIORegistryLongProperty(childDevice, "idProduct")) != 0L) {
                    productIdMap.put(childId.getValue(), String.format("%04x", 0xFFFFL & productId));
                }
                if ((serial = IOKitUtil.getIORegistryStringProperty(childDevice, "USB Serial Number")) != null) {
                    serialMap.put(childId.getValue(), serial);
                }
                IOKit.INSTANCE.IOObjectRelease(childDevice);
                childDevice = IOKit.INSTANCE.IOIteratorNext(childIter.getValue());
            }
            IOKit.INSTANCE.IOObjectRelease(childIter.getValue());
            IOKit.INSTANCE.IOObjectRelease(device);
            device = IOKit.INSTANCE.IOIteratorNext(iter.getValue());
        }
        IOKit.INSTANCE.IOObjectRelease(iter.getValue());
        ArrayList<MacUsbDevice> controllerDevices = new ArrayList<MacUsbDevice>();
        for (Long controller : usbControllers) {
            controllerDevices.add(MacUsbDevice.getDeviceAndChildren(controller, "0000", "0000"));
        }
        return controllerDevices.toArray(new UsbDevice[controllerDevices.size()]);
    }

    private static void getControllerIdByLocation(long id, CoreFoundation.CFTypeRef locationId) {
        CoreFoundation.CFMutableDictionaryRef propertyDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
        CoreFoundation.INSTANCE.CFDictionarySetValue(propertyDict, CfUtil.getCFString("locationID"), locationId);
        CoreFoundation.CFMutableDictionaryRef matchingDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
        CoreFoundation.INSTANCE.CFDictionarySetValue(matchingDict, CfUtil.getCFString("IOPropertyMatch"), propertyDict);
        IntByReference serviceIterator = new IntByReference();
        IOKitUtil.getMatchingServices(matchingDict, serviceIterator);
        CfUtil.release(propertyDict);
        boolean found = false;
        int matchingService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
        while (matchingService != 0 && !found) {
            byte[] pid;
            IntByReference parent = new IntByReference();
            IOKit.INSTANCE.IORegistryEntryGetParentEntry(matchingService, "IOService", parent);
            byte[] vid = IOKitUtil.getIORegistryByteArrayProperty(parent.getValue(), "vendor-id");
            if (vid != null && vid.length >= 2) {
                vendorIdMap.put(id, String.format("%02x%02x", vid[1], vid[0]));
                found = true;
            }
            if ((pid = IOKitUtil.getIORegistryByteArrayProperty(parent.getValue(), "device-id")) != null && pid.length >= 2) {
                productIdMap.put(id, String.format("%02x%02x", pid[1], pid[0]));
                found = true;
            }
            matchingService = IOKit.INSTANCE.IOIteratorNext(matchingService);
        }
    }

    private static MacUsbDevice getDeviceAndChildren(Long registryEntryId, String vid, String pid) {
        String vendorId = MapUtil.getOrDefault(vendorIdMap, registryEntryId, vid);
        String productId = MapUtil.getOrDefault(productIdMap, registryEntryId, pid);
        List childIds = MapUtil.getOrDefault(hubMap, registryEntryId, new ArrayList());
        ArrayList<MacUsbDevice> usbDevices = new ArrayList<MacUsbDevice>();
        for (Long id : childIds) {
            usbDevices.add(MacUsbDevice.getDeviceAndChildren(id, vendorId, productId));
        }
        Collections.sort(usbDevices);
        return new MacUsbDevice(MapUtil.getOrDefault(nameMap, registryEntryId, vendorId + ":" + productId), MapUtil.getOrDefault(vendorMap, registryEntryId, ""), vendorId, productId, MapUtil.getOrDefault(serialMap, registryEntryId, ""), usbDevices.toArray(new UsbDevice[usbDevices.size()]));
    }
}

