/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.Libc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SolarisCentralProcessor.class);

    public SolarisCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("cpu_info", -1, null);
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            this.setVendor(KstatUtil.kstatDataLookupString(ksp, "vendor_id"));
            this.setName(KstatUtil.kstatDataLookupString(ksp, "brand"));
            this.setStepping(KstatUtil.kstatDataLookupString(ksp, "stepping"));
            this.setModel(KstatUtil.kstatDataLookupString(ksp, "model"));
            this.setFamily(KstatUtil.kstatDataLookupString(ksp, "family"));
        }
        this.setCpu64("64".equals(ExecutingCommand.getFirstAnswer("isainfo -b").trim()));
        this.setProcessorID(this.getProcessorID(this.getStepping(), this.getModel(), this.getFamily()));
    }

    @Override
    protected void calculateProcessorCounts() {
        List<LibKstat.Kstat> kstats = KstatUtil.kstatLookupAll("cpu_info", -1, null);
        HashSet<String> chipIDs = new HashSet<String>();
        HashSet<String> coreIDs = new HashSet<String>();
        this.logicalProcessorCount = 0;
        for (LibKstat.Kstat ksp : kstats) {
            if (ksp == null || !KstatUtil.kstatRead(ksp)) continue;
            ++this.logicalProcessorCount;
            String chipId = KstatUtil.kstatDataLookupString(ksp, "chip_id");
            String coreId = KstatUtil.kstatDataLookupString(ksp, "core_id");
            chipIDs.add(chipId);
            coreIDs.add(coreId + ":" + chipId);
        }
        this.physicalPackageCount = chipIDs.size();
        if (this.physicalPackageCount < 1) {
            LOG.error("Couldn't find physical package count. Assuming 1.");
            this.physicalPackageCount = 1;
        }
        this.physicalProcessorCount = coreIDs.size();
        if (this.physicalProcessorCount < 1) {
            LOG.error("Couldn't find physical processor count. Assuming 1.");
            this.physicalProcessorCount = 1;
        }
        if (this.logicalProcessorCount < 1) {
            LOG.error("Couldn't find logical processor count. Assuming 1.");
            this.logicalProcessorCount = 1;
        }
    }

    @Override
    public synchronized long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        long[][] procTicks = this.getProcessorCpuLoadTicks();
        int i = 0;
        while (i < ticks.length) {
            for (long[] procTick : procTicks) {
                int n = i;
                ticks[n] = ticks[n] + procTick[i];
            }
            int n = i++;
            ticks[n] = ticks[n] / (long)procTicks.length;
        }
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = Libc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        int cpu = -1;
        for (LibKstat.Kstat ksp : KstatUtil.kstatLookupAll("cpu", -1, "sys")) {
            if (++cpu >= ticks.length) break;
            if (!KstatUtil.kstatRead(ksp)) continue;
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_idle");
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_kernel");
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = KstatUtil.kstatDataLookupLong(ksp, "cpu_ticks_user");
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("unix", 0, "system_misc");
        if (ksp == null) {
            return 0L;
        }
        return ksp.ks_snaptime / 1000000000L;
    }

    private String getProcessorID(String stepping, String model, String family) {
        List<String> isainfo = ExecutingCommand.runNative("isainfo -v");
        StringBuilder flags = new StringBuilder();
        for (String line : isainfo) {
            if (line.startsWith("32-bit")) break;
            if (line.startsWith("64-bit")) continue;
            flags.append(' ').append(line.trim());
        }
        return this.createProcessorID(stepping, model, family, ParseUtil.whitespaces.split(flags.toString().toLowerCase()));
    }

    @Override
    public long getContextSwitches() {
        long swtch = 0L;
        List<String> kstat = ExecutingCommand.runNative("kstat -p cpu_stat:::/pswitch\\\\|inv_swtch/");
        for (String s : kstat) {
            swtch += ParseUtil.parseLastLong(s, 0L);
        }
        return swtch > 0L ? swtch : -1L;
    }

    @Override
    public long getInterrupts() {
        long intr = 0L;
        List<String> kstat = ExecutingCommand.runNative("kstat -p cpu_stat:::/intr/");
        for (String s : kstat) {
            intr += ParseUtil.parseLastLong(s, 0L);
        }
        return intr > 0L ? intr : -1L;
    }
}

