/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.util.Arrays;
import oshi.hardware.Sensors;
import oshi.util.platform.mac.SmcUtil;

public class MacSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private double lastTemp = 0.0;
    private long lastTempTime;
    private int numFans = 0;
    private int[] lastFanSpeeds = new int[0];
    private long lastFanSpeedsTime;
    private double lastVolts = 0.0;
    private long lastVoltsTime;

    public MacSensors() {
        SmcUtil.smcOpen();
        this.lastTemp = this.getCpuTemperature();
        this.lastFanSpeeds = this.getFanSpeeds();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SmcUtil.smcClose();
            }
        });
    }

    @Override
    public double getCpuTemperature() {
        double temp;
        if (System.currentTimeMillis() - this.lastTempTime > 900L && (temp = SmcUtil.smcGetFloat("TC0P", 50)) > 0.0) {
            this.lastTemp = temp;
            this.lastTempTime = System.currentTimeMillis();
        }
        return this.lastTemp;
    }

    @Override
    public int[] getFanSpeeds() {
        if (System.currentTimeMillis() - this.lastFanSpeedsTime > 900L) {
            if (this.numFans == 0) {
                this.numFans = (int)SmcUtil.smcGetLong("FNum", 50);
                this.lastFanSpeeds = new int[this.numFans];
            }
            for (int i = 0; i < this.numFans; ++i) {
                int speed = (int)SmcUtil.smcGetFloat(String.format("F%dAc", i), 50);
                if (speed <= 0) continue;
                this.lastFanSpeeds[i] = speed;
                this.lastFanSpeedsTime = System.currentTimeMillis();
            }
        }
        return Arrays.copyOf(this.lastFanSpeeds, this.lastFanSpeeds.length);
    }

    @Override
    public double getCpuVoltage() {
        double kiloVolts;
        if (System.currentTimeMillis() - this.lastVoltsTime > 900L && (kiloVolts = SmcUtil.smcGetFloat("VC0C", 50)) > 0.0) {
            this.lastVolts = kiloVolts / 1000.0;
            this.lastVoltsTime = System.currentTimeMillis();
        }
        return this.lastVolts;
    }
}

