/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.linux;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oshi.jna.platform.unix.CLibrary;

public interface Libc
extends CLibrary {
    public static final Libc INSTANCE = (Libc)Native.load((String)"c", Libc.class);

    public int sysinfo(Sysinfo var1);

    public int statvfs(String var1, Statvfs var2);

    @Structure.FieldOrder(value={"fsBlockSize", "fsFragmentSize", "fsSizeInBlocks", "fsBlocksFree", "fsBlocksFreeUnpriv", "fsTotalInodeCount", "fsFreeInodeCount", "fsFreeInodeCountUnpriv", "fsId", "_fPad32bit", "fsMountFlags", "fsMaxFilenameLength", "_fSpare"})
    public static class Statvfs
    extends Structure {
        private static final int PADDING_SIZE = 8 / NativeLong.SIZE - 1;
        public NativeLong fsBlockSize;
        public NativeLong fsFragmentSize;
        public NativeLong fsSizeInBlocks;
        public NativeLong fsBlocksFree;
        public NativeLong fsBlocksFreeUnpriv;
        public NativeLong fsTotalInodeCount;
        public NativeLong fsFreeInodeCount;
        public NativeLong fsFreeInodeCountUnpriv;
        public NativeLong fsId;
        public int[] _fPad32bit = new int[PADDING_SIZE];
        public NativeLong fsMountFlags;
        public NativeLong fsMaxFilenameLength;
        public int[] _fSpare = new int[6];

        protected List<Field> getFieldList() {
            ArrayList<Field> fields = new ArrayList<Field>(super.getFieldList());
            if (PADDING_SIZE == 0) {
                Iterator fieldIterator = fields.iterator();
                while (fieldIterator.hasNext()) {
                    Field field = (Field)fieldIterator.next();
                    if (!"_fPad32bit".equals(field.getName())) continue;
                    fieldIterator.remove();
                }
            }
            return fields;
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> fieldOrder = new ArrayList<String>(super.getFieldOrder());
            if (PADDING_SIZE == 0) {
                fieldOrder.remove("_fPad32bit");
            }
            return fieldOrder;
        }
    }

    @Structure.FieldOrder(value={"uptime", "loads", "totalram", "freeram", "sharedram", "bufferram", "totalswap", "freeswap", "procs", "totalhigh", "freehigh", "mem_unit", "_f"})
    public static class Sysinfo
    extends Structure {
        private static final int PADDING_SIZE = 20 - 2 * NativeLong.SIZE - 4;
        public NativeLong uptime;
        public NativeLong[] loads = new NativeLong[3];
        public NativeLong totalram;
        public NativeLong freeram;
        public NativeLong sharedram;
        public NativeLong bufferram;
        public NativeLong totalswap;
        public NativeLong freeswap;
        public short procs;
        public NativeLong totalhigh;
        public NativeLong freehigh;
        public int mem_unit;
        public byte[] _f = new byte[PADDING_SIZE];

        protected List<Field> getFieldList() {
            ArrayList<Field> fields = new ArrayList<Field>(super.getFieldList());
            if (PADDING_SIZE == 0) {
                Iterator fieldIterator = fields.iterator();
                while (fieldIterator.hasNext()) {
                    Field field = (Field)fieldIterator.next();
                    if (!"_f".equals(field.getName())) continue;
                    fieldIterator.remove();
                }
            }
            return fields;
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> fieldOrder = new ArrayList<String>(super.getFieldOrder());
            if (PADDING_SIZE == 0) {
                fieldOrder.remove("_f");
            }
            return fieldOrder;
        }
    }
}

