/*
 * Decompiled with CFR 0.152.
 */
package oshi.ffm.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import oshi.ffm.ForeignFunctions;
import oshi.ffm.windows.WinNTFFM;

public abstract class WindowsForeignFunctions
extends ForeignFunctions {
    protected WindowsForeignFunctions() {
    }

    public static boolean isSuccess(int winBool) {
        return winBool != 0;
    }

    public static MemorySegment setupTokenPrivileges(Arena arena, MemorySegment luid) {
        MemorySegment tkp = arena.allocate(WinNTFFM.TOKEN_PRIVILEGES);
        tkp.set(ValueLayout.JAVA_INT, WinNTFFM.TOKEN_PRIVILEGES_PRIVILEGE_COUNT_OFFSET, 1);
        MemorySegment luidSegment = tkp.asSlice(WinNTFFM.TOKEN_PRIVILEGES_LUID_OFFSET, luid.byteSize());
        luidSegment.copyFrom(luid);
        tkp.set(ValueLayout.JAVA_INT, WinNTFFM.TOKEN_PRIVILEGES_ATTRIBUTES_OFFSET, 2);
        return tkp;
    }

    public static MemorySegment toWideString(Arena arena, String s) {
        return arena.allocateFrom(s + "\u0000", StandardCharsets.UTF_16LE);
    }
}

