/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.mac.disk;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class Fsstat {
    private Fsstat() {
    }

    public static int queryFsstat(SystemB.Statfs[] buf, int bufsize, int flags) {
        return SystemB.INSTANCE.getfsstat64(buf, bufsize, flags);
    }

    public static SystemB.Statfs[] getFileSystems(int numfs) {
        SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
        Fsstat.queryFsstat(fs, numfs * new SystemB.Statfs().size(), 16);
        return fs;
    }

    public static Map<String, String> queryPartitionToMountMap() {
        HashMap<String, String> mountPointMap = new HashMap<String, String>();
        int numfs = SystemB.INSTANCE.getfsstat64(null, 0, 0);
        SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
        SystemB.INSTANCE.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
        for (SystemB.Statfs f : fs) {
            String mntFrom = Native.toString((byte[])f.f_mntfromname, (Charset)StandardCharsets.UTF_8);
            mountPointMap.put(mntFrom.replace("/dev/", ""), Native.toString((byte[])f.f_mntonname, (Charset)StandardCharsets.UTF_8));
        }
        return mountPointMap;
    }
}

