/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.jaxp.validation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import mf.javax.xml.stream.XMLEventFactory;
import mf.javax.xml.stream.XMLEventWriter;
import mf.javax.xml.stream.XMLStreamException;
import mf.javax.xml.stream.XMLStreamReader;
import mf.javax.xml.stream.events.Characters;
import mf.javax.xml.stream.events.Comment;
import mf.javax.xml.stream.events.DTD;
import mf.javax.xml.stream.events.EndDocument;
import mf.javax.xml.stream.events.EntityReference;
import mf.javax.xml.stream.events.ProcessingInstruction;
import mf.javax.xml.stream.events.StartDocument;
import mf.javax.xml.stream.events.XMLEvent;
import mf.javax.xml.transform.stax.StAXResult;
import mf.org.apache.xerces.jaxp.validation.StAXDocumentHandler;
import mf.org.apache.xerces.jaxp.validation.StAXValidatorHelper;
import mf.org.apache.xerces.util.JAXPNamespaceContextWrapper;
import mf.org.apache.xerces.xni.Augmentations;
import mf.org.apache.xerces.xni.NamespaceContext;
import mf.org.apache.xerces.xni.QName;
import mf.org.apache.xerces.xni.XMLAttributes;
import mf.org.apache.xerces.xni.XMLLocator;
import mf.org.apache.xerces.xni.XMLResourceIdentifier;
import mf.org.apache.xerces.xni.XMLString;
import mf.org.apache.xerces.xni.XNIException;
import mf.org.apache.xerces.xni.parser.XMLDocumentSource;

final class StAXEventResultBuilder
implements StAXDocumentHandler {
    private XMLEventWriter fEventWriter;
    private final XMLEventFactory fEventFactory;
    private final StAXValidatorHelper fStAXValidatorHelper;
    private final JAXPNamespaceContextWrapper fNamespaceContext;
    private boolean fIgnoreChars;
    private boolean fInCDATA;
    private final QName fAttrName = new QName();
    private static final Iterator EMPTY_COLLECTION_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public StAXEventResultBuilder(StAXValidatorHelper helper, JAXPNamespaceContextWrapper context) {
        this.fStAXValidatorHelper = helper;
        this.fNamespaceContext = context;
        this.fEventFactory = XMLEventFactory.newInstance();
    }

    public void setStAXResult(StAXResult result) {
        this.fIgnoreChars = false;
        this.fInCDATA = false;
        this.fEventWriter = result != null ? result.getXMLEventWriter() : null;
    }

    public void startDocument(XMLStreamReader reader) throws XMLStreamException {
        String version = reader.getVersion();
        String encoding = reader.getCharacterEncodingScheme();
        boolean standalone = reader.standaloneSet();
        this.fEventWriter.add(this.fEventFactory.createStartDocument(encoding != null ? encoding : "UTF-8", version != null ? version : "1.0", standalone));
    }

    public void endDocument(XMLStreamReader reader) throws XMLStreamException {
        this.fEventWriter.add(this.fEventFactory.createEndDocument());
        this.fEventWriter.flush();
    }

    public void comment(XMLStreamReader reader) throws XMLStreamException {
        this.fEventWriter.add(this.fEventFactory.createComment(reader.getText()));
    }

    public void processingInstruction(XMLStreamReader reader) throws XMLStreamException {
        String data = reader.getPIData();
        this.fEventWriter.add(this.fEventFactory.createProcessingInstruction(reader.getPITarget(), data != null ? data : ""));
    }

    public void entityReference(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getLocalName();
        this.fEventWriter.add(this.fEventFactory.createEntityReference(name, this.fStAXValidatorHelper.getEntityDeclaration(name)));
    }

    public void startDocument(StartDocument event) throws XMLStreamException {
        this.fEventWriter.add(event);
    }

    public void endDocument(EndDocument event) throws XMLStreamException {
        this.fEventWriter.add(event);
        this.fEventWriter.flush();
    }

    public void doctypeDecl(DTD event) throws XMLStreamException {
        this.fEventWriter.add(event);
    }

    public void characters(Characters event) throws XMLStreamException {
        this.fEventWriter.add(event);
    }

    public void cdata(Characters event) throws XMLStreamException {
        this.fEventWriter.add(event);
    }

    public void comment(Comment event) throws XMLStreamException {
        this.fEventWriter.add(event);
    }

    public void processingInstruction(ProcessingInstruction event) throws XMLStreamException {
        this.fEventWriter.add(event);
    }

    public void entityReference(EntityReference event) throws XMLStreamException {
        this.fEventWriter.add(event);
    }

    public void setIgnoringCharacters(boolean ignore) {
        this.fIgnoreChars = ignore;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        try {
            XMLEvent start;
            int length = attributes.getLength();
            if (length == 0 && (start = this.fStAXValidatorHelper.getCurrentEvent()) != null) {
                this.fEventWriter.add(start);
                return;
            }
            this.fEventWriter.add(this.fEventFactory.createStartElement(element.prefix, element.uri != null ? element.uri : "", element.localpart, this.getAttributeIterator(attributes, length), this.getNamespaceIterator(), this.fNamespaceContext.getNamespaceContext()));
        }
        catch (XMLStreamException e) {
            throw new XNIException(e);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fIgnoreChars) {
            try {
                if (!this.fInCDATA) {
                    this.fEventWriter.add(this.fEventFactory.createCharacters(text.toString()));
                } else {
                    this.fEventWriter.add(this.fEventFactory.createCData(text.toString()));
                }
            }
            catch (XMLStreamException e) {
                throw new XNIException(e);
            }
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.characters(text, augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        try {
            XMLEvent end = this.fStAXValidatorHelper.getCurrentEvent();
            if (end != null) {
                this.fEventWriter.add(end);
            } else {
                this.fEventWriter.add(this.fEventFactory.createEndElement(element.prefix, element.uri, element.localpart, this.getNamespaceIterator()));
            }
        }
        catch (XMLStreamException e) {
            throw new XNIException(e);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.fInCDATA = true;
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.fInCDATA = false;
    }

    public void endDocument(Augmentations augs) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource source) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    private Iterator getAttributeIterator(XMLAttributes attributes, int length) {
        return length > 0 ? new AttributeIterator(attributes, length) : EMPTY_COLLECTION_ITERATOR;
    }

    private Iterator getNamespaceIterator() {
        int length = this.fNamespaceContext.getDeclaredPrefixCount();
        return length > 0 ? new NamespaceIterator(length) : EMPTY_COLLECTION_ITERATOR;
    }

    final class NamespaceIterator
    implements Iterator {
        mf.javax.xml.namespace.NamespaceContext fNC;
        int fIndex;
        int fEnd;

        NamespaceIterator(int length) {
            this.fNC = StAXEventResultBuilder.this.fNamespaceContext.getNamespaceContext();
            this.fIndex = 0;
            this.fEnd = length;
        }

        public boolean hasNext() {
            if (this.fIndex < this.fEnd) {
                return true;
            }
            this.fNC = null;
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String prefix = StAXEventResultBuilder.this.fNamespaceContext.getDeclaredPrefixAt(this.fIndex++);
            String uri = this.fNC.getNamespaceURI(prefix);
            if (prefix.length() == 0) {
                return StAXEventResultBuilder.this.fEventFactory.createNamespace(uri != null ? uri : "");
            }
            return StAXEventResultBuilder.this.fEventFactory.createNamespace(prefix, uri != null ? uri : "");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    final class AttributeIterator
    implements Iterator {
        XMLAttributes fAttributes;
        int fIndex;
        int fEnd;

        AttributeIterator(XMLAttributes attributes, int length) {
            this.fAttributes = attributes;
            this.fIndex = 0;
            this.fEnd = length;
        }

        public boolean hasNext() {
            if (this.fIndex < this.fEnd) {
                return true;
            }
            this.fAttributes = null;
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.fAttributes.getName(this.fIndex, StAXEventResultBuilder.this.fAttrName);
            return StAXEventResultBuilder.this.fEventFactory.createAttribute(((StAXEventResultBuilder)StAXEventResultBuilder.this).fAttrName.prefix, ((StAXEventResultBuilder)StAXEventResultBuilder.this).fAttrName.uri != null ? ((StAXEventResultBuilder)StAXEventResultBuilder.this).fAttrName.uri : "", ((StAXEventResultBuilder)StAXEventResultBuilder.this).fAttrName.localpart, this.fAttributes.getValue(this.fIndex++));
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

