/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.dom;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import mf.org.apache.xerces.dom.AttrImpl;
import mf.org.apache.xerces.dom.CharacterDataImpl;
import mf.org.apache.xerces.dom.CoreDocumentImpl;
import mf.org.apache.xerces.dom.DOMImplementationImpl;
import mf.org.apache.xerces.dom.DOMMessageFormatter;
import mf.org.apache.xerces.dom.LCount;
import mf.org.apache.xerces.dom.NodeImpl;
import mf.org.apache.xerces.dom.NodeIteratorImpl;
import mf.org.apache.xerces.dom.RangeImpl;
import mf.org.apache.xerces.dom.TreeWalkerImpl;
import mf.org.apache.xerces.dom.events.EventImpl;
import mf.org.apache.xerces.dom.events.MouseEventImpl;
import mf.org.apache.xerces.dom.events.MutationEventImpl;
import mf.org.apache.xerces.dom.events.UIEventImpl;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.DOMException;
import mf.org.w3c.dom.DOMImplementation;
import mf.org.w3c.dom.DocumentType;
import mf.org.w3c.dom.Element;
import mf.org.w3c.dom.NamedNodeMap;
import mf.org.w3c.dom.Node;
import mf.org.w3c.dom.events.DocumentEvent;
import mf.org.w3c.dom.events.Event;
import mf.org.w3c.dom.events.EventException;
import mf.org.w3c.dom.events.EventListener;
import mf.org.w3c.dom.ranges.DocumentRange;
import mf.org.w3c.dom.ranges.Range;
import mf.org.w3c.dom.traversal.DocumentTraversal;
import mf.org.w3c.dom.traversal.NodeFilter;
import mf.org.w3c.dom.traversal.NodeIterator;
import mf.org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends CoreDocumentImpl
implements DocumentTraversal,
DocumentEvent,
DocumentRange {
    static final long serialVersionUID = 515687835542616694L;
    protected transient List iterators;
    protected transient ReferenceQueue iteratorReferenceQueue;
    protected transient List ranges;
    protected transient ReferenceQueue rangeReferenceQueue;
    protected Hashtable eventListeners;
    protected boolean mutationEvents = false;
    EnclosingAttr savedEnclosingAttr;

    public DocumentImpl() {
    }

    public DocumentImpl(boolean grammarAccess) {
        super(grammarAccess);
    }

    public DocumentImpl(DocumentType doctype) {
        super(doctype);
    }

    public DocumentImpl(DocumentType doctype, boolean grammarAccess) {
        super(doctype, grammarAccess);
    }

    public Node cloneNode(boolean deep) {
        DocumentImpl newdoc = new DocumentImpl();
        this.callUserDataHandlers(this, newdoc, (short)1);
        this.cloneNode(newdoc, deep);
        newdoc.mutationEvents = this.mutationEvents;
        return newdoc;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public NodeIterator createNodeIterator(Node root, short whatToShow, NodeFilter filter) {
        return this.createNodeIterator(root, whatToShow, filter, true);
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        if (root == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, msg);
        }
        NodeIteratorImpl iterator = new NodeIteratorImpl(this, root, whatToShow, filter, entityReferenceExpansion);
        if (this.iterators == null) {
            this.iterators = new LinkedList();
            this.iteratorReferenceQueue = new ReferenceQueue();
        }
        this.removeStaleIteratorReferences();
        this.iterators.add(new WeakReference<NodeIteratorImpl>(iterator, this.iteratorReferenceQueue));
        return iterator;
    }

    public TreeWalker createTreeWalker(Node root, short whatToShow, NodeFilter filter) {
        return this.createTreeWalker(root, whatToShow, filter, true);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        if (root == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, msg);
        }
        return new TreeWalkerImpl(root, whatToShow, filter, entityReferenceExpansion);
    }

    void removeNodeIterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return;
        }
        if (this.iterators == null) {
            return;
        }
        this.removeStaleIteratorReferences();
        Iterator i = this.iterators.iterator();
        while (i.hasNext()) {
            Object iterator = ((Reference)i.next()).get();
            if (iterator == nodeIterator) {
                i.remove();
                return;
            }
            if (iterator != null) continue;
            i.remove();
        }
    }

    private void removeStaleIteratorReferences() {
        this.removeStaleReferences(this.iteratorReferenceQueue, this.iterators);
    }

    private void removeStaleReferences(ReferenceQueue queue, List list) {
        Reference ref = queue.poll();
        int count = 0;
        while (ref != null) {
            ++count;
            ref = queue.poll();
        }
        if (count > 0) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object o = ((Reference)i.next()).get();
                if (o != null) continue;
                i.remove();
                if (--count > 0) continue;
                return;
            }
        }
    }

    public Range createRange() {
        if (this.ranges == null) {
            this.ranges = new LinkedList();
            this.rangeReferenceQueue = new ReferenceQueue();
        }
        RangeImpl range = new RangeImpl(this);
        this.removeStaleRangeReferences();
        this.ranges.add(new WeakReference<RangeImpl>(range, this.rangeReferenceQueue));
        return range;
    }

    void removeRange(Range range) {
        if (range == null) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        this.removeStaleRangeReferences();
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            Object otherRange = ((Reference)i.next()).get();
            if (otherRange == range) {
                i.remove();
                return;
            }
            if (otherRange != null) continue;
            i.remove();
        }
    }

    void replacedText(CharacterDataImpl node) {
        if (this.ranges != null) {
            this.notifyRangesReplacedText(node);
        }
    }

    private void notifyRangesReplacedText(CharacterDataImpl node) {
        this.removeStaleRangeReferences();
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            RangeImpl range = (RangeImpl)((Reference)i.next()).get();
            if (range != null) {
                range.receiveReplacedText(node);
                continue;
            }
            i.remove();
        }
    }

    void deletedText(CharacterDataImpl node, int offset, int count) {
        if (this.ranges != null) {
            this.notifyRangesDeletedText(node, offset, count);
        }
    }

    private void notifyRangesDeletedText(CharacterDataImpl node, int offset, int count) {
        this.removeStaleRangeReferences();
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            RangeImpl range = (RangeImpl)((Reference)i.next()).get();
            if (range != null) {
                range.receiveDeletedText(node, offset, count);
                continue;
            }
            i.remove();
        }
    }

    void insertedText(CharacterDataImpl node, int offset, int count) {
        if (this.ranges != null) {
            this.notifyRangesInsertedText(node, offset, count);
        }
    }

    private void notifyRangesInsertedText(CharacterDataImpl node, int offset, int count) {
        this.removeStaleRangeReferences();
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            RangeImpl range = (RangeImpl)((Reference)i.next()).get();
            if (range != null) {
                range.receiveInsertedText(node, offset, count);
                continue;
            }
            i.remove();
        }
    }

    void splitData(Node node, Node newNode, int offset) {
        if (this.ranges != null) {
            this.notifyRangesSplitData(node, newNode, offset);
        }
    }

    private void notifyRangesSplitData(Node node, Node newNode, int offset) {
        this.removeStaleRangeReferences();
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            RangeImpl range = (RangeImpl)((Reference)i.next()).get();
            if (range != null) {
                range.receiveSplitData(node, newNode, offset);
                continue;
            }
            i.remove();
        }
    }

    private void removeStaleRangeReferences() {
        this.removeStaleReferences(this.rangeReferenceQueue, this.ranges);
    }

    public Event createEvent(String type) throws DOMException {
        if (type.equalsIgnoreCase("Events") || "Event".equals(type)) {
            return new EventImpl();
        }
        if (type.equalsIgnoreCase("MutationEvents") || "MutationEvent".equals(type)) {
            return new MutationEventImpl();
        }
        if (type.equalsIgnoreCase("UIEvents") || "UIEvent".equals(type)) {
            return new UIEventImpl();
        }
        if (type.equalsIgnoreCase("MouseEvents") || "MouseEvent".equals(type)) {
            return new MouseEventImpl();
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
        throw new DOMException(9, msg);
    }

    void setMutationEvents(boolean set) {
        this.mutationEvents = set;
    }

    boolean getMutationEvents() {
        return this.mutationEvents;
    }

    protected void setEventListeners(NodeImpl n, Vector listeners) {
        if (this.eventListeners == null) {
            this.eventListeners = new Hashtable();
        }
        if (listeners == null) {
            this.eventListeners.remove(n);
            if (this.eventListeners.isEmpty()) {
                this.mutationEvents = false;
            }
        } else {
            this.eventListeners.put(n, listeners);
            this.mutationEvents = true;
        }
    }

    protected Vector getEventListeners(NodeImpl n) {
        if (this.eventListeners == null) {
            return null;
        }
        return (Vector)this.eventListeners.get(n);
    }

    protected void addEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
        if (type == null || type.length() == 0 || listener == null) {
            return;
        }
        this.removeEventListener(node, type, listener, useCapture);
        Vector<LEntry> nodeListeners = this.getEventListeners(node);
        if (nodeListeners == null) {
            nodeListeners = new Vector<LEntry>();
            this.setEventListeners(node, nodeListeners);
        }
        nodeListeners.addElement(new LEntry(type, listener, useCapture));
        LCount lc = LCount.lookup(type);
        if (useCapture) {
            ++lc.captures;
            ++lc.total;
        } else {
            ++lc.bubbles;
            ++lc.total;
        }
    }

    protected void removeEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
        if (type == null || type.length() == 0 || listener == null) {
            return;
        }
        Vector nodeListeners = this.getEventListeners(node);
        if (nodeListeners == null) {
            return;
        }
        for (int i = nodeListeners.size() - 1; i >= 0; --i) {
            LEntry le = (LEntry)nodeListeners.elementAt(i);
            if (le.useCapture != useCapture || le.listener != listener || !le.type.equals(type)) continue;
            nodeListeners.removeElementAt(i);
            if (nodeListeners.size() == 0) {
                this.setEventListeners(node, null);
            }
            LCount lc = LCount.lookup(type);
            if (useCapture) {
                --lc.captures;
                --lc.total;
                break;
            }
            --lc.bubbles;
            --lc.total;
            break;
        }
    }

    protected void copyEventListeners(NodeImpl src, NodeImpl tgt) {
        Vector nodeListeners = this.getEventListeners(src);
        if (nodeListeners == null) {
            return;
        }
        this.setEventListeners(tgt, (Vector)nodeListeners.clone());
    }

    protected boolean dispatchEvent(NodeImpl node, Event event) {
        if (event == null) {
            return false;
        }
        EventImpl evt = (EventImpl)event;
        if (!evt.initialized || evt.type == null || evt.type.length() == 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "UNSPECIFIED_EVENT_TYPE_ERR", null);
            throw new EventException(0, msg);
        }
        LCount lc = LCount.lookup(evt.getType());
        if (lc.total == 0) {
            return evt.preventDefault;
        }
        evt.target = node;
        evt.stopPropagation = false;
        evt.preventDefault = false;
        ArrayList<Node> pv = new ArrayList<Node>(10);
        Node p = node;
        for (Node n = p.getParentNode(); n != null; n = n.getParentNode()) {
            pv.add(n);
            p = n;
        }
        if (lc.captures > 0) {
            evt.eventPhase = 1;
            for (int j = pv.size() - 1; j >= 0 && !evt.stopPropagation; --j) {
                NodeImpl nn = (NodeImpl)pv.get(j);
                evt.currentTarget = nn;
                Vector nodeListeners = this.getEventListeners(nn);
                if (nodeListeners == null) continue;
                Vector nl = (Vector)nodeListeners.clone();
                int nlsize = nl.size();
                for (int i2 = 0; i2 < nlsize; ++i2) {
                    LEntry le = (LEntry)nl.elementAt(i2);
                    if (!le.useCapture || !le.type.equals(evt.type) || !nodeListeners.contains(le)) continue;
                    try {
                        le.listener.handleEvent(evt);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (lc.bubbles > 0) {
            evt.eventPhase = (short)2;
            evt.currentTarget = node;
            Vector nodeListeners = this.getEventListeners(node);
            if (!evt.stopPropagation && nodeListeners != null) {
                Vector nl = (Vector)nodeListeners.clone();
                int nlsize = nl.size();
                for (int i = 0; i < nlsize; ++i) {
                    LEntry le = (LEntry)nl.elementAt(i);
                    if (le.useCapture || !le.type.equals(evt.type) || !nodeListeners.contains(le)) continue;
                    try {
                        le.listener.handleEvent(evt);
                        continue;
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                }
            }
            if (evt.bubbles) {
                evt.eventPhase = (short)3;
                int pvsize = pv.size();
                for (int j = 0; j < pvsize && !evt.stopPropagation; ++j) {
                    NodeImpl nn = (NodeImpl)pv.get(j);
                    evt.currentTarget = nn;
                    nodeListeners = this.getEventListeners(nn);
                    if (nodeListeners == null) continue;
                    Vector nl = (Vector)nodeListeners.clone();
                    int nlsize = nl.size();
                    for (int i = 0; i < nlsize; ++i) {
                        LEntry le = (LEntry)nl.elementAt(i);
                        if (le.useCapture || !le.type.equals(evt.type) || !nodeListeners.contains(le)) continue;
                        try {
                            le.listener.handleEvent(evt);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (lc.defaults <= 0 || !evt.cancelable || !evt.preventDefault) {
            // empty if block
        }
        return evt.preventDefault;
    }

    protected void dispatchEventToSubtree(Node n, Event e) {
        ((NodeImpl)n).dispatchEvent(e);
        if (n.getNodeType() == 1) {
            NamedNodeMap a = n.getAttributes();
            for (int i = a.getLength() - 1; i >= 0; --i) {
                this.dispatchingEventToSubtree(a.item(i), e);
            }
        }
        this.dispatchingEventToSubtree(n.getFirstChild(), e);
    }

    protected void dispatchingEventToSubtree(Node n, Event e) {
        if (n == null) {
            return;
        }
        ((NodeImpl)n).dispatchEvent(e);
        if (n.getNodeType() == 1) {
            NamedNodeMap a = n.getAttributes();
            for (int i = a.getLength() - 1; i >= 0; --i) {
                this.dispatchingEventToSubtree(a.item(i), e);
            }
        }
        this.dispatchingEventToSubtree(n.getFirstChild(), e);
        this.dispatchingEventToSubtree(n.getNextSibling(), e);
    }

    protected void dispatchAggregateEvents(NodeImpl node, EnclosingAttr ea) {
        if (ea != null) {
            this.dispatchAggregateEvents(node, ea.node, ea.oldvalue, (short)1);
        } else {
            this.dispatchAggregateEvents(node, null, null, (short)0);
        }
    }

    protected void dispatchAggregateEvents(NodeImpl node, AttrImpl enclosingAttr, String oldvalue, short change) {
        MutationEventImpl me;
        LCount lc;
        NodeImpl owner = null;
        if (enclosingAttr != null) {
            lc = LCount.lookup("DOMAttrModified");
            owner = (NodeImpl)((Object)enclosingAttr.getOwnerElement());
            if (lc.total > 0 && owner != null) {
                me = new MutationEventImpl();
                me.initMutationEvent("DOMAttrModified", true, false, enclosingAttr, oldvalue, enclosingAttr.getNodeValue(), enclosingAttr.getNodeName(), change);
                owner.dispatchEvent(me);
            }
        }
        lc = LCount.lookup("DOMSubtreeModified");
        if (lc.total > 0) {
            me = new MutationEventImpl();
            me.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)0);
            if (enclosingAttr != null) {
                this.dispatchEvent(enclosingAttr, me);
                if (owner != null) {
                    this.dispatchEvent(owner, me);
                }
            } else {
                this.dispatchEvent(node, me);
            }
        }
    }

    protected void saveEnclosingAttr(NodeImpl node) {
        this.savedEnclosingAttr = null;
        LCount lc = LCount.lookup("DOMAttrModified");
        if (lc.total > 0) {
            NodeImpl eventAncestor = node;
            while (true) {
                if (eventAncestor == null) {
                    return;
                }
                short type = eventAncestor.getNodeType();
                if (type == 2) {
                    EnclosingAttr retval = new EnclosingAttr();
                    retval.node = (AttrImpl)eventAncestor;
                    retval.oldvalue = retval.node.getNodeValue();
                    this.savedEnclosingAttr = retval;
                    return;
                }
                if (type == 5) {
                    eventAncestor = eventAncestor.parentNode();
                    continue;
                }
                if (type != 3) break;
                eventAncestor = eventAncestor.parentNode();
            }
            return;
        }
    }

    void modifyingCharacterData(NodeImpl node, boolean replace) {
        if (this.mutationEvents && !replace) {
            this.saveEnclosingAttr(node);
        }
    }

    void modifiedCharacterData(NodeImpl node, String oldvalue, String value, boolean replace) {
        if (this.mutationEvents) {
            this.mutationEventsModifiedCharacterData(node, oldvalue, value, replace);
        }
    }

    private void mutationEventsModifiedCharacterData(NodeImpl node, String oldvalue, String value, boolean replace) {
        if (!replace) {
            LCount lc = LCount.lookup("DOMCharacterDataModified");
            if (lc.total > 0) {
                MutationEventImpl me = new MutationEventImpl();
                me.initMutationEvent("DOMCharacterDataModified", true, false, null, oldvalue, value, null, (short)0);
                this.dispatchEvent(node, me);
            }
            this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
        }
    }

    void replacedCharacterData(NodeImpl node, String oldvalue, String value) {
        this.modifiedCharacterData(node, oldvalue, value, false);
    }

    void insertingNode(NodeImpl node, boolean replace) {
        if (this.mutationEvents && !replace) {
            this.saveEnclosingAttr(node);
        }
    }

    void insertedNode(NodeImpl node, NodeImpl newInternal, boolean replace) {
        if (this.mutationEvents) {
            this.mutationEventsInsertedNode(node, newInternal, replace);
        }
        if (this.ranges != null) {
            this.notifyRangesInsertedNode(newInternal);
        }
    }

    private void mutationEventsInsertedNode(NodeImpl node, NodeImpl newInternal, boolean replace) {
        LCount lc = LCount.lookup("DOMNodeInserted");
        if (lc.total > 0) {
            MutationEventImpl me = new MutationEventImpl();
            me.initMutationEvent("DOMNodeInserted", true, false, node, null, null, null, (short)0);
            this.dispatchEvent(newInternal, me);
        }
        lc = LCount.lookup("DOMNodeInsertedIntoDocument");
        if (lc.total > 0) {
            NodeImpl eventAncestor = node;
            if (this.savedEnclosingAttr != null) {
                eventAncestor = (NodeImpl)((Object)this.savedEnclosingAttr.node.getOwnerElement());
            }
            if (eventAncestor != null) {
                NodeImpl p = eventAncestor;
                while (p != null) {
                    eventAncestor = p;
                    if (p.getNodeType() == 2) {
                        p = (NodeImpl)((Object)((AttrImpl)p).getOwnerElement());
                        continue;
                    }
                    p = p.parentNode();
                }
                if (eventAncestor.getNodeType() == 9) {
                    MutationEventImpl me = new MutationEventImpl();
                    me.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null, (short)0);
                    this.dispatchEventToSubtree(newInternal, me);
                }
            }
        }
        if (!replace) {
            this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
        }
    }

    private void notifyRangesInsertedNode(NodeImpl newInternal) {
        this.removeStaleRangeReferences();
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            RangeImpl range = (RangeImpl)((Reference)i.next()).get();
            if (range != null) {
                range.insertedNodeFromDOM(newInternal);
                continue;
            }
            i.remove();
        }
    }

    void removingNode(NodeImpl node, NodeImpl oldChild, boolean replace) {
        if (this.iterators != null) {
            this.notifyIteratorsRemovingNode(oldChild);
        }
        if (this.ranges != null) {
            this.notifyRangesRemovingNode(oldChild);
        }
        if (this.mutationEvents) {
            this.mutationEventsRemovingNode(node, oldChild, replace);
        }
    }

    private void notifyIteratorsRemovingNode(NodeImpl oldChild) {
        this.removeStaleIteratorReferences();
        Iterator i = this.iterators.iterator();
        while (i.hasNext()) {
            NodeIteratorImpl iterator = (NodeIteratorImpl)((Reference)i.next()).get();
            if (iterator != null) {
                iterator.removeNode(oldChild);
                continue;
            }
            i.remove();
        }
    }

    private void notifyRangesRemovingNode(NodeImpl oldChild) {
        this.removeStaleRangeReferences();
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            RangeImpl range = (RangeImpl)((Reference)i.next()).get();
            if (range != null) {
                range.removeNode(oldChild);
                continue;
            }
            i.remove();
        }
    }

    private void mutationEventsRemovingNode(NodeImpl node, NodeImpl oldChild, boolean replace) {
        if (!replace) {
            this.saveEnclosingAttr(node);
        }
        LCount lc = LCount.lookup("DOMNodeRemoved");
        if (lc.total > 0) {
            MutationEventImpl me = new MutationEventImpl();
            me.initMutationEvent("DOMNodeRemoved", true, false, node, null, null, null, (short)0);
            this.dispatchEvent(oldChild, me);
        }
        lc = LCount.lookup("DOMNodeRemovedFromDocument");
        if (lc.total > 0) {
            NodeImpl eventAncestor = this;
            if (this.savedEnclosingAttr != null) {
                eventAncestor = (NodeImpl)((Object)this.savedEnclosingAttr.node.getOwnerElement());
            }
            if (eventAncestor != null) {
                for (NodeImpl p = ((NodeImpl)eventAncestor).parentNode(); p != null; p = p.parentNode()) {
                    eventAncestor = p;
                }
                if (((NodeImpl)eventAncestor).getNodeType() == 9) {
                    MutationEventImpl me = new MutationEventImpl();
                    me.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null, (short)0);
                    this.dispatchEventToSubtree(oldChild, me);
                }
            }
        }
    }

    void removedNode(NodeImpl node, boolean replace) {
        if (this.mutationEvents && !replace) {
            this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
        }
    }

    void replacingNode(NodeImpl node) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(node);
        }
    }

    void replacingData(NodeImpl node) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(node);
        }
    }

    void replacedNode(NodeImpl node) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
        }
    }

    void modifiedAttrValue(AttrImpl attr, String oldvalue) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents(attr, attr, oldvalue, (short)1);
        }
    }

    void setAttrNode(AttrImpl attr, AttrImpl previous) {
        if (this.mutationEvents) {
            if (previous == null) {
                this.dispatchAggregateEvents(attr.ownerNode, attr, null, (short)2);
            } else {
                this.dispatchAggregateEvents(attr.ownerNode, attr, previous.getNodeValue(), (short)1);
            }
        }
    }

    void removedAttrNode(AttrImpl attr, NodeImpl oldOwner, String name) {
        if (this.mutationEvents) {
            this.mutationEventsRemovedAttrNode(attr, oldOwner, name);
        }
    }

    private void mutationEventsRemovedAttrNode(AttrImpl attr, NodeImpl oldOwner, String name) {
        LCount lc = LCount.lookup("DOMAttrModified");
        if (lc.total > 0) {
            MutationEventImpl me = new MutationEventImpl();
            me.initMutationEvent("DOMAttrModified", true, false, attr, attr.getNodeValue(), null, name, (short)3);
            this.dispatchEvent(oldOwner, me);
        }
        this.dispatchAggregateEvents(oldOwner, null, null, (short)0);
    }

    void renamedAttrNode(Attr oldAt, Attr newAt) {
    }

    void renamedElement(Element oldEl, Element newEl) {
    }

    class EnclosingAttr
    implements Serializable {
        private static final long serialVersionUID = 5208387723391647216L;
        AttrImpl node;
        String oldvalue;

        EnclosingAttr() {
        }
    }

    class LEntry
    implements Serializable {
        private static final long serialVersionUID = -8426757059492421631L;
        String type;
        EventListener listener;
        boolean useCapture;

        LEntry(String type, EventListener listener, boolean useCapture) {
            this.type = type;
            this.listener = listener;
            this.useCapture = useCapture;
        }
    }
}

