/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators.functions;

import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.evaluation.FunctionCallException;
import com.nedap.archie.rules.evaluation.FunctionImplementation;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.evaluators.FunctionUtil;
import java.util.ArrayList;
import java.util.List;

public class Sum
implements FunctionImplementation {
    @Override
    public String getName() {
        return "sum";
    }

    @Override
    public ValueList evaluate(List<ValueList> arguments) throws FunctionCallException {
        ValueList possiblyNullResult = FunctionUtil.checkAndHandleNull(arguments);
        if (possiblyNullResult != null) {
            possiblyNullResult.setType(PrimitiveType.Real);
            return possiblyNullResult;
        }
        int length = FunctionUtil.checkEqualLengthOrOne(arguments);
        ValueList result = new ValueList();
        for (int i = 0; i < length; ++i) {
            Double sum = 0.0;
            ArrayList<String> paths = new ArrayList<String>();
            for (ValueList argument : arguments) {
                Object value;
                if (argument.getValues().size() == 1) {
                    if (argument.getValues().get(0).isNull()) {
                        sum = null;
                        break;
                    }
                    paths.addAll(argument.getValues().get(0).getPaths());
                    value = argument.getValues().get(0).getValue();
                    if (value instanceof Number) {
                        sum = sum + ((Number)value).doubleValue();
                        continue;
                    }
                    throw new FunctionCallException("argument of sum is not a number");
                }
                if (argument.getValues().get(i).isNull()) {
                    sum = null;
                    break;
                }
                paths.addAll(argument.getValues().get(i).getPaths());
                value = argument.getValues().get(i).getValue();
                if (value instanceof Number) {
                    sum = sum + ((Number)value).doubleValue();
                    continue;
                }
                throw new FunctionCallException("argument of sum is not a number");
            }
            result.addValue(sum, paths);
        }
        result.setType(PrimitiveType.Real);
        return result;
    }
}

