/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation;

import com.google.common.collect.Lists;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rules.evaluation.AssertionResult;
import com.nedap.archie.rules.evaluation.EmptyRMObjectConstructor;
import com.nedap.archie.rules.evaluation.RuleEvaluation;
import com.nedap.archie.rules.evaluation.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionsFixer {
    private static final Logger logger = LoggerFactory.getLogger(AssertionsFixer.class);
    private final RMObjectCreator creator;
    private final RuleEvaluation ruleEvaluation;
    private final EmptyRMObjectConstructor emptyRMObjectConstructor;
    private ModelInfoLookup modelInfoLookup;

    public AssertionsFixer(RuleEvaluation evaluation, RMObjectCreator creator) {
        this.creator = creator;
        this.ruleEvaluation = evaluation;
        this.modelInfoLookup = this.ruleEvaluation.getModelInfoLookup();
        this.emptyRMObjectConstructor = new EmptyRMObjectConstructor(evaluation.getModelInfoLookup());
    }

    public Map<String, Object> fixAssertions(Archetype archetype, AssertionResult assertionResult) {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            Map<String, Value> setPathValues = assertionResult.getSetPathValues();
            for (String path : setPathValues.keySet()) {
                Value value = setPathValues.get(path);
                String pathOfParent = this.stripLastPathSegment(path);
                String lastPathSegment = this.getLastPathSegment(path);
                List<Object> parents = null;
                parents = this.ruleEvaluation.getQueryContext().findList(pathOfParent);
                while (parents.isEmpty()) {
                    this.constructMissingStructure(archetype, pathOfParent, lastPathSegment, parents);
                    parents = this.ruleEvaluation.getQueryContext().findList(pathOfParent);
                }
                for (Object t : parents) {
                    Number convertedValue;
                    RMAttributeInfo attributeInfo = this.ruleEvaluation.getModelInfoLookup().getAttributeInfo(t.getClass(), lastPathSegment);
                    if (attributeInfo == null) {
                        throw new IllegalStateException("attribute " + lastPathSegment + " does not exist on type " + t.getClass());
                    }
                    if (value.getValue() == null) {
                        this.creator.set(t, lastPathSegment, Lists.newArrayList((Object[])new Object[]{value.getValue()}));
                    } else if (attributeInfo.getType().equals(Long.class) && value.getValue().getClass().equals(Double.class)) {
                        convertedValue = ((Double)value.getValue()).longValue();
                        this.creator.set(t, lastPathSegment, Lists.newArrayList((Object[])new Object[]{convertedValue}));
                    } else if (attributeInfo.getType().equals(Double.class) && value.getValue().getClass().equals(Long.class)) {
                        convertedValue = ((Long)value.getValue()).doubleValue();
                        this.creator.set(t, lastPathSegment, Lists.newArrayList((Object[])new Object[]{convertedValue}));
                    } else {
                        this.creator.set(t, lastPathSegment, Lists.newArrayList((Object[])new Object[]{value.getValue()}));
                    }
                    result = this.modelInfoLookup.pathHasBeenUpdated(this.ruleEvaluation.getRMRoot(), archetype, pathOfParent, t);
                    this.ruleEvaluation.refreshQueryContext();
                }
            }
        }
        catch (XPathExpressionException e) {
            logger.error("error fixing assertionResult {}", (Object)assertionResult, (Object)e);
        }
        return result;
    }

    private void constructMissingStructure(Archetype archetype, String pathOfParent, String lastPathSegment, List<Object> parents) throws XPathExpressionException {
        String newPathOfParent = pathOfParent;
        String newLastPathSegment = lastPathSegment;
        while (parents.isEmpty()) {
            newLastPathSegment = this.getLastPathSegment(newPathOfParent);
            newPathOfParent = this.stripLastPathSegment(newPathOfParent);
            parents = this.ruleEvaluation.getQueryContext().findList(newPathOfParent);
        }
        List constraints = newPathOfParent.equals("/") ? archetype.itemsAtPath("/" + newLastPathSegment) : archetype.itemsAtPath(newPathOfParent + "/" + newLastPathSegment);
        if (this.constraintsHasNoComplexObjects(constraints)) {
            Object object = parents.get(0);
            Object newEmptyObject = null;
            newEmptyObject = this.constructEmptySimpleObject(newLastPathSegment, object, newEmptyObject);
            this.creator.addElementToListOrSetSingleValues(object, newLastPathSegment, Lists.newArrayList((Object[])new Object[]{newEmptyObject}));
            this.ruleEvaluation.refreshQueryContext();
        } else {
            CObject constraint = this.getCObjectFromResult(constraints);
            if (constraint != null) {
                Object object = parents.get(0);
                Object newEmptyObject = null;
                newEmptyObject = constraint instanceof CComplexObject ? this.emptyRMObjectConstructor.constructEmptyRMObject(constraint) : this.constructEmptySimpleObject(newLastPathSegment, object, newEmptyObject);
                int bracketIndex = newLastPathSegment.indexOf(91);
                String attributeName = newLastPathSegment;
                if (bracketIndex > -1) {
                    attributeName = newLastPathSegment.substring(0, bracketIndex);
                }
                this.creator.addElementToListOrSetSingleValues(object, attributeName, Lists.newArrayList((Object[])new Object[]{newEmptyObject}));
                this.ruleEvaluation.refreshQueryContext();
            }
        }
    }

    private CObject getCObjectFromResult(List<? extends ArchetypeModelObject> objects) {
        if (objects.size() != 1) {
            return null;
        }
        ArchetypeModelObject object = objects.get(0);
        if (object instanceof CAttribute) {
            return this.getCObjectFromResult(((CAttribute)object).getChildren());
        }
        return (CObject)object;
    }

    private Object constructEmptySimpleObject(String newLastPathSegment, Object object, Object newEmptyObject) {
        RMAttributeInfo attributeInfo = this.ruleEvaluation.getModelInfoLookup().getAttributeInfo(object.getClass(), newLastPathSegment);
        try {
            newEmptyObject = attributeInfo.getTypeInCollection().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return newEmptyObject;
    }

    private boolean constraintsHasNoComplexObjects(List<? extends ArchetypeModelObject> constraints) {
        for (ArchetypeModelObject archetypeModelObject : constraints) {
            if (!(archetypeModelObject instanceof CAttribute ? !this.constraintsHasNoComplexObjects(((CAttribute)archetypeModelObject).getChildren()) : archetypeModelObject instanceof CComplexObject)) continue;
            return false;
        }
        return true;
    }

    private String stripLastPathSegment(String path) {
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex < 0) {
            return path;
        }
        String result = path.substring(0, lastIndex);
        if (result.equals("")) {
            return "/";
        }
        return result;
    }

    private String getLastPathSegment(String path) {
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex < 0) {
            return path;
        }
        return path.substring(lastIndex + 1);
    }
}

