/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.json.flat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.creation.ExampleJsonInstanceGenerator;
import com.nedap.archie.json.flat.DuplicateKeyException;
import com.nedap.archie.json.flat.FlatJsonFormatConfiguration;
import com.nedap.archie.json.flat.FlatJsonGenerator;
import com.nedap.archie.rminfo.MetaModels;
import java.util.Map;

public class FlatJsonExampleInstanceGenerator {
    public Map<String, Object> generateExample(OperationalTemplate template, MetaModels metaModels, String language, FlatJsonFormatConfiguration jsonFormatConfiguration) throws JsonProcessingException, DuplicateKeyException {
        metaModels.selectModel((Archetype)template);
        if (metaModels.getSelectedModel() == null) {
            throw new IllegalArgumentException("Cannot find MetaModel for archetype");
        }
        if (metaModels.getSelectedModelInfoLookup() == null) {
            throw new IllegalArgumentException("Cannot find ModelInfoLookup for archetype");
        }
        if (metaModels.getSelectedModel().getJsonObjectMapper() == null) {
            throw new IllegalArgumentException("Cannot find JSON Object mapper in selected metamodel");
        }
        ExampleJsonInstanceGenerator exampleJsonInstanceGenerator = new ExampleJsonInstanceGenerator(metaModels, language);
        exampleJsonInstanceGenerator.setTypePropertyName("_type");
        Map<String, Object> generatedExample = exampleJsonInstanceGenerator.generate(template);
        ObjectMapper objectMapper = metaModels.getSelectedModel().getJsonObjectMapper();
        String jsonRmObject = objectMapper.writeValueAsString(generatedExample);
        OpenEHRBase openEHRBase = (OpenEHRBase)objectMapper.readValue(jsonRmObject, OpenEHRBase.class);
        return new FlatJsonGenerator(metaModels.getSelectedModelInfoLookup(), jsonFormatConfiguration).buildPathsAndValues(openEHRBase);
    }
}

