/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.flattener.ArchetypeRepository;
import com.nedap.archie.flattener.SimpleArchetypeRepository;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class OverridingArchetypeRepository
implements ArchetypeRepository {
    private ArchetypeRepository root;
    private SimpleArchetypeRepository overrides;

    public OverridingArchetypeRepository(ArchetypeRepository root) {
        this.root = root;
        this.overrides = new SimpleArchetypeRepository();
    }

    public void addExtraArchetype(Archetype archetype) {
        this.overrides.addArchetype(archetype);
    }

    @Override
    public Archetype getArchetype(String archetypeId) {
        Archetype result = this.overrides.getArchetype(archetypeId);
        if (result == null) {
            result = this.root.getArchetype(archetypeId);
        }
        return result;
    }

    @Override
    public List<Archetype> getAllArchetypes() {
        LinkedHashMap result = new LinkedHashMap();
        this.root.getAllArchetypes().forEach(a -> result.put(a.getArchetypeId().toString(), a));
        this.overrides.getAllArchetypes().forEach(a -> result.put(a.getArchetypeId().toString(), a));
        return new ArrayList<Archetype>(result.values());
    }
}

