/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.github.zafarkhaja.semver.Version;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.definitions.VersionStatus;
import com.nedap.archie.flattener.CustomVersionComparator;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ArchetypeHRIDMap<T>
extends ConcurrentHashMap<ArchetypeHRID, T> {
    public T getLatestVersion(String archetypeId) throws IllegalArgumentException {
        return this.getLatestVersion(new ArchetypeHRID(archetypeId));
    }

    public T getLatestVersion(ArchetypeHRID archetypeHRID) {
        if (archetypeHRID.getVersionStatus() == VersionStatus.BUILD) {
            return (T)this.get(archetypeHRID);
        }
        List keys = this.keySet().stream().filter(id -> id.getIdUpToConcept().equals(archetypeHRID.getIdUpToConcept())).filter(id -> archetypeHRID.getMajorVersion() == null || id.getMajorVersion().equals(archetypeHRID.getMajorVersion())).filter(id -> archetypeHRID.getMinorVersion() == null || id.getMinorVersion().equals(archetypeHRID.getMinorVersion())).filter(id -> archetypeHRID.getPatchVersion() == null || id.getPatchVersion().equals(archetypeHRID.getPatchVersion())).collect(Collectors.toList());
        keys.sort(Comparator.comparing(o -> Version.valueOf((String)o.getVersionId()), new CustomVersionComparator()));
        return keys.size() == 0 ? null : (T)this.get(keys.get(keys.size() - 1));
    }
}

